/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.converter;

import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import pl.allegro.tech.hermes.api.ContentType;
import pl.allegro.tech.hermes.api.Topic;
import pl.allegro.tech.hermes.common.message.converter.AvroRecordToBytesConverter;
import pl.allegro.tech.hermes.consumers.consumer.Message;
import pl.allegro.tech.hermes.consumers.consumer.converter.MessageConverter;
import tech.allegro.schema.json2avro.converter.JsonAvroConverter;

public class AvroToJsonMessageConverter
implements MessageConverter {
    private final JsonAvroConverter converter = new JsonAvroConverter();

    @Inject
    public AvroToJsonMessageConverter() {
    }

    @Override
    public Message convert(Message message, Topic topic) {
        return Message.message().fromMessage(message).withContentType(ContentType.JSON).withData(this.converter.convertToJson(this.recordWithoutMetadata(message.getData(), (Schema)message.getSchema().get().getSchema()))).withNoSchema().build();
    }

    private GenericRecord recordWithoutMetadata(byte[] data, Schema schema) {
        GenericRecord original = AvroRecordToBytesConverter.bytesToRecord((byte[])data, (Schema)schema);
        Schema schemaWithoutMetadata = this.removeMetadataField(schema);
        GenericRecordBuilder builder = new GenericRecordBuilder(schemaWithoutMetadata);
        schemaWithoutMetadata.getFields().forEach(field -> builder.set(field, original.get(field.name())));
        return builder.build();
    }

    private Schema removeMetadataField(Schema schema) {
        return Schema.createRecord(schema.getFields().stream().filter(field -> !"__metadata".equals(field.name())).map(field -> new Schema.Field(field.name(), field.schema(), field.doc(), field.defaultVal())).collect(Collectors.toList()));
    }
}

