/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.rate.maxrate;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.MaxRate;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.SubscriptionIdMapper;
import pl.allegro.tech.hermes.consumers.subscription.id.SubscriptionId;

class ConsumerMaxRates {
    private final Map<SubscriptionName, MaxRate> maxRates = new ConcurrentHashMap<SubscriptionName, MaxRate>();

    ConsumerMaxRates() {
    }

    void setAllMaxRates(ConsumerMaxRates newMaxRates) {
        this.maxRates.clear();
        this.maxRates.putAll(newMaxRates.maxRates);
    }

    Optional<MaxRate> getMaxRate(SubscriptionName subscription) {
        return Optional.ofNullable(this.maxRates.get(subscription));
    }

    void setMaxRate(SubscriptionName subscription, MaxRate maxRate) {
        this.maxRates.put(subscription, maxRate);
    }

    public void cleanup(Set<SubscriptionName> subscriptions) {
        this.maxRates.entrySet().removeIf(entry -> !subscriptions.contains(entry.getKey()));
    }

    int size() {
        return this.maxRates.size();
    }

    Map<SubscriptionId, MaxRate> toSubscriptionsIdsMap(SubscriptionIdMapper subscriptionIdMapping) {
        return this.maxRates.keySet().stream().map(subscriptionIdMapping::mapToSubscriptionId).filter(Optional::isPresent).collect(Collectors.toMap(Optional::get, subscriptionId -> this.maxRates.get(((SubscriptionId)subscriptionId.get()).getSubscriptionName())));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConsumerMaxRates that = (ConsumerMaxRates)o;
        return Objects.equals(this.maxRates, that.maxRates);
    }

    public int hashCode() {
        return Objects.hash(this.maxRates);
    }
}

