/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender.http;

import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.util.BytesContentProvider;
import org.eclipse.jetty.http.HttpMethod;
import pl.allegro.tech.hermes.consumers.consumer.Message;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.HttpRequestFactory;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.headers.HttpRequestHeaders;
import pl.allegro.tech.hermes.consumers.consumer.trace.MetadataAppender;

class DefaultHttpRequestFactory
implements HttpRequestFactory {
    private final HttpClient client;
    private final long timeout;
    private final long socketTimeout;
    private final MetadataAppender<Request> metadataAppender;

    public DefaultHttpRequestFactory(HttpClient client, long timeout, long socketTimeout, MetadataAppender<Request> metadataAppender) {
        this.client = client;
        this.timeout = timeout;
        this.socketTimeout = socketTimeout;
        this.metadataAppender = metadataAppender;
    }

    @Override
    public Request buildRequest(Message message, URI uri, HttpRequestHeaders headers) {
        return new HttpRequestBuilder(message, uri, headers).build();
    }

    private class HttpRequestBuilder {
        private final Message message;
        private final URI uri;
        private final HttpRequestHeaders headers;

        HttpRequestBuilder(Message message, URI uri, HttpRequestHeaders headers) {
            this.message = message;
            this.uri = uri;
            this.headers = headers;
        }

        Request build() {
            Request request = this.baseRequest();
            this.headers.asMap().forEach((arg_0, arg_1) -> ((Request)request).header(arg_0, arg_1));
            return request;
        }

        private Request baseRequest() {
            Request baseRequest = DefaultHttpRequestFactory.this.client.newRequest(this.uri).method(HttpMethod.POST).timeout(DefaultHttpRequestFactory.this.timeout, TimeUnit.MILLISECONDS).idleTimeout(DefaultHttpRequestFactory.this.socketTimeout, TimeUnit.MILLISECONDS).content((ContentProvider)new BytesContentProvider((byte[][])new byte[][]{this.message.getData()}));
            DefaultHttpRequestFactory.this.metadataAppender.append(baseRequest, this.message);
            return baseRequest;
        }
    }
}

