/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.process;

import com.google.common.collect.ImmutableMap;
import java.time.Clock;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import pl.allegro.tech.hermes.consumers.queue.MpscQueue;
import pl.allegro.tech.hermes.consumers.supervisor.process.Signal;

class SignalsFilter {
    private static final Map<Signal.SignalType, Signal.SignalType> MERGEABLE_SIGNALS = ImmutableMap.builder().put((Object)Signal.SignalType.START, (Object)Signal.SignalType.STOP).put((Object)Signal.SignalType.STOP, (Object)Signal.SignalType.START).build();
    private final Clock clock;
    private final MpscQueue<Signal> taskQueue;

    SignalsFilter(MpscQueue<Signal> taskQueue, Clock clock) {
        this.taskQueue = taskQueue;
        this.clock = clock;
    }

    List<Signal> filterSignals(List<Signal> signals) {
        ArrayList<Signal> filteredSignals = new ArrayList<Signal>(signals.size());
        for (Signal signal : signals) {
            boolean merged = this.merge(filteredSignals, signal);
            if (merged) continue;
            if (signal.canExecuteNow(this.clock.millis())) {
                this.addWithoutDuplicationMergeableSignals(filteredSignals, signal);
                continue;
            }
            this.taskQueue.offer(signal);
        }
        return filteredSignals;
    }

    private void addWithoutDuplicationMergeableSignals(List<Signal> filteredSignals, Signal signal) {
        if (MERGEABLE_SIGNALS.containsKey((Object)signal.getType())) {
            if (!filteredSignals.contains(signal)) {
                filteredSignals.add(signal);
            }
        } else {
            filteredSignals.add(signal);
        }
    }

    private boolean merge(List<Signal> filteredSignals, Signal signal) {
        Signal.SignalType signalTypeToMerge = MERGEABLE_SIGNALS.get((Object)signal.getType());
        if (signalTypeToMerge != null) {
            return filteredSignals.remove(signal.createChild(signalTypeToMerge));
        }
        return false;
    }
}

