/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.config;

import java.time.Duration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import pl.allegro.tech.hermes.consumers.CommonConsumerParameters;
import pl.allegro.tech.hermes.consumers.consumer.SerialConsumerParameters;
import pl.allegro.tech.hermes.consumers.supervisor.workload.SupervisorParameters;

@ConfigurationProperties(prefix="consumer")
public class CommonConsumerProperties
implements CommonConsumerParameters {
    private int threadPoolSize = 500;
    private int healthCheckPort = 8000;
    private Duration subscriptionIdsCacheRemovedExpireAfterAccess = Duration.ofSeconds(60L);
    private SupervisorParameters backgroundSupervisor = new BackgroundSupervisor();
    private SerialConsumerParameters serialConsumer = new SerialConsumer();
    private int signalProcessingQueueSize = 5000;
    private boolean useTopicMessageSizeEnabled = false;
    private Duration undeliveredMessageLogPersistPeriod = Duration.ofSeconds(5L);

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    public int getHealthCheckPort() {
        return this.healthCheckPort;
    }

    public void setHealthCheckPort(int healthCheckPort) {
        this.healthCheckPort = healthCheckPort;
    }

    public Duration getSubscriptionIdsCacheRemovedExpireAfterAccess() {
        return this.subscriptionIdsCacheRemovedExpireAfterAccess;
    }

    public void setSubscriptionIdsCacheRemovedExpireAfterAccess(Duration subscriptionIdsCacheRemovedExpireAfterAccess) {
        this.subscriptionIdsCacheRemovedExpireAfterAccess = subscriptionIdsCacheRemovedExpireAfterAccess;
    }

    @Override
    public SupervisorParameters getBackgroundSupervisor() {
        return this.backgroundSupervisor;
    }

    public void setBackgroundSupervisor(SupervisorParameters backgroundSupervisor) {
        this.backgroundSupervisor = backgroundSupervisor;
    }

    @Override
    public SerialConsumerParameters getSerialConsumer() {
        return this.serialConsumer;
    }

    public void setSerialConsumer(SerialConsumerParameters serialConsumer) {
        this.serialConsumer = serialConsumer;
    }

    @Override
    public int getSignalProcessingQueueSize() {
        return this.signalProcessingQueueSize;
    }

    public void setSignalProcessingQueueSize(int signalProcessingQueueSize) {
        this.signalProcessingQueueSize = signalProcessingQueueSize;
    }

    @Override
    public boolean isUseTopicMessageSizeEnabled() {
        return this.useTopicMessageSizeEnabled;
    }

    public void setUseTopicMessageSizeEnabled(boolean useTopicMessageSizeEnabled) {
        this.useTopicMessageSizeEnabled = useTopicMessageSizeEnabled;
    }

    public Duration getUndeliveredMessageLogPersistPeriod() {
        return this.undeliveredMessageLogPersistPeriod;
    }

    public void setUndeliveredMessageLogPersistPeriod(Duration undeliveredMessageLogPersistPeriod) {
        this.undeliveredMessageLogPersistPeriod = undeliveredMessageLogPersistPeriod;
    }

    public static final class BackgroundSupervisor
    implements SupervisorParameters {
        private Duration interval = Duration.ofMillis(20000L);
        private Duration unhealthyAfter = Duration.ofMillis(600000L);
        private Duration killAfter = Duration.ofMillis(300000L);

        @Override
        public Duration getInterval() {
            return this.interval;
        }

        public void setInterval(Duration interval) {
            this.interval = interval;
        }

        @Override
        public Duration getUnhealthyAfter() {
            return this.unhealthyAfter;
        }

        public void setUnhealthyAfter(Duration unhealthyAfter) {
            this.unhealthyAfter = unhealthyAfter;
        }

        @Override
        public Duration getKillAfter() {
            return this.killAfter;
        }

        public void setKillAfter(Duration killAfter) {
            this.killAfter = killAfter;
        }
    }

    public static final class SerialConsumer
    implements SerialConsumerParameters {
        private Duration signalProcessingInterval = Duration.ofMillis(5000L);
        private int inflightSize = 100;

        @Override
        public Duration getSignalProcessingInterval() {
            return this.signalProcessingInterval;
        }

        public void setSignalProcessingInterval(Duration signalProcessingInterval) {
            this.signalProcessingInterval = signalProcessingInterval;
        }

        @Override
        public int getInflightSize() {
            return this.inflightSize;
        }

        public void setInflightSize(int inflightSize) {
            this.inflightSize = inflightSize;
        }
    }
}

