/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.config;

import java.time.Duration;
import java.util.UUID;
import org.springframework.boot.context.properties.ConfigurationProperties;
import pl.allegro.tech.hermes.common.util.InetAddressInstanceIdResolver;
import pl.allegro.tech.hermes.consumers.supervisor.workload.selective.SelectiveSupervisorParameters;

@ConfigurationProperties(prefix="consumer.workload")
public class WorkloadProperties
implements SelectiveSupervisorParameters {
    private int registryBinaryEncoderAssignmentsBufferSizeBytes = 100000;
    private Duration rebalanceInterval = Duration.ofSeconds(30L);
    private int consumersPerSubscription = 2;
    private int maxSubscriptionsPerConsumer = 200;
    private int assignmentProcessingThreadPoolSize = 5;
    private String nodeId = new InetAddressInstanceIdResolver().resolve().replaceAll("\\.", "_") + "$" + Math.abs(UUID.randomUUID().getMostSignificantBits());
    private Duration monitorScanInterval = Duration.ofSeconds(120L);
    private boolean autoRebalance = true;
    private Duration deadAfter = Duration.ofSeconds(120L);

    public int getRegistryBinaryEncoderAssignmentsBufferSizeBytes() {
        return this.registryBinaryEncoderAssignmentsBufferSizeBytes;
    }

    public void setRegistryBinaryEncoderAssignmentsBufferSizeBytes(int registryBinaryEncoderAssignmentsBufferSizeBytes) {
        this.registryBinaryEncoderAssignmentsBufferSizeBytes = registryBinaryEncoderAssignmentsBufferSizeBytes;
    }

    @Override
    public Duration getRebalanceInterval() {
        return this.rebalanceInterval;
    }

    public void setRebalanceInterval(Duration rebalanceInterval) {
        this.rebalanceInterval = rebalanceInterval;
    }

    @Override
    public int getConsumersPerSubscription() {
        return this.consumersPerSubscription;
    }

    public void setConsumersPerSubscription(int consumersPerSubscription) {
        this.consumersPerSubscription = consumersPerSubscription;
    }

    @Override
    public int getMaxSubscriptionsPerConsumer() {
        return this.maxSubscriptionsPerConsumer;
    }

    public void setMaxSubscriptionsPerConsumer(int maxSubscriptionsPerConsumer) {
        this.maxSubscriptionsPerConsumer = maxSubscriptionsPerConsumer;
    }

    public int getAssignmentProcessingThreadPoolSize() {
        return this.assignmentProcessingThreadPoolSize;
    }

    public void setAssignmentProcessingThreadPoolSize(int assignmentProcessingThreadPoolSize) {
        this.assignmentProcessingThreadPoolSize = assignmentProcessingThreadPoolSize;
    }

    @Override
    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public Duration getMonitorScanInterval() {
        return this.monitorScanInterval;
    }

    public void setMonitorScanInterval(Duration monitorScanInterval) {
        this.monitorScanInterval = monitorScanInterval;
    }

    @Override
    public boolean isAutoRebalance() {
        return this.autoRebalance;
    }

    public void setAutoRebalance(boolean autoRebalance) {
        this.autoRebalance = autoRebalance;
    }

    public Duration getDeadAfter() {
        return this.deadAfter;
    }

    public void setDeadAfter(Duration deadAfter) {
        this.deadAfter = deadAfter;
    }
}

