/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.workload;

import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.curator.framework.CuratorFramework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.consumers.subscription.id.SubscriptionIds;
import pl.allegro.tech.hermes.consumers.supervisor.workload.ConsumerWorkloadEncoder;
import pl.allegro.tech.hermes.consumers.supervisor.workload.SubscriptionAssignmentView;
import pl.allegro.tech.hermes.consumers.supervisor.workload.WorkDistributionChanges;
import pl.allegro.tech.hermes.consumers.supervisor.workload.WorkloadRegistryPaths;
import pl.allegro.tech.hermes.consumers.supervisor.workload.ZookeeperOperations;
import pl.allegro.tech.hermes.infrastructure.zookeeper.ZookeeperPaths;

public class ConsumerAssignmentRegistry {
    private static final Logger logger = LoggerFactory.getLogger(ConsumerAssignmentRegistry.class);
    private final ZookeeperOperations zookeeper;
    private final ConsumerWorkloadEncoder consumerAssignmentsEncoder;
    private final WorkloadRegistryPaths paths;

    public ConsumerAssignmentRegistry(CuratorFramework curator, int assignmentsEncoderBufferSize, String clusterName, ZookeeperPaths zookeeperPaths, SubscriptionIds subscriptionIds) {
        this.zookeeper = new ZookeeperOperations(curator);
        this.consumerAssignmentsEncoder = new ConsumerWorkloadEncoder(subscriptionIds, assignmentsEncoderBufferSize);
        this.paths = new WorkloadRegistryPaths(zookeeperPaths, clusterName);
    }

    public WorkDistributionChanges updateAssignments(SubscriptionAssignmentView initialState, SubscriptionAssignmentView targetState) {
        if (initialState.equals(targetState)) {
            return WorkDistributionChanges.NO_CHANGES;
        }
        SubscriptionAssignmentView deletions = initialState.deletions(targetState);
        SubscriptionAssignmentView additions = initialState.additions(targetState);
        Sets.SetView modifiedConsumerNodes = Sets.union(deletions.getConsumerNodes(), additions.getConsumerNodes());
        for (String consumerNode : modifiedConsumerNodes) {
            Set<SubscriptionName> subscriptions = targetState.getSubscriptionsForConsumerNode(consumerNode);
            byte[] encoded = this.consumerAssignmentsEncoder.encode(subscriptions);
            try {
                logger.info("Writing {} bytes of {} assignments for consumer {}", new Object[]{encoded.length, subscriptions.size(), consumerNode});
                String path = this.paths.consumerWorkloadPath(consumerNode);
                this.zookeeper.writeOrCreatePersistent(path, encoded);
            }
            catch (Exception e) {
                logger.error("Could not write consumer workload for {}", (Object)consumerNode);
            }
        }
        return new WorkDistributionChanges(deletions.getAllAssignments().size(), additions.getAllAssignments().size());
    }
}

