/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender.googlepubsub;

import com.google.pubsub.v1.TopicName;
import java.util.Objects;

class GooglePubSubSenderTarget {
    private final TopicName topicName;
    private final String pubSubEndpoint;

    private GooglePubSubSenderTarget(TopicName topicName, String pubSubEndpoint) {
        this.topicName = topicName;
        this.pubSubEndpoint = pubSubEndpoint;
    }

    TopicName getTopicName() {
        return this.topicName;
    }

    String getPubSubEndpoint() {
        return this.pubSubEndpoint;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GooglePubSubSenderTarget that = (GooglePubSubSenderTarget)o;
        return Objects.equals(this.topicName, that.topicName) && Objects.equals(this.pubSubEndpoint, that.pubSubEndpoint);
    }

    public int hashCode() {
        return Objects.hash(this.topicName, this.pubSubEndpoint);
    }

    static PubSubTargetBuilder builder() {
        return new PubSubTargetBuilder();
    }

    static final class PubSubTargetBuilder {
        private TopicName topicName;
        private String pubSubEndpoint;

        private PubSubTargetBuilder() {
        }

        PubSubTargetBuilder withTopicName(TopicName topicName) {
            this.topicName = topicName;
            return this;
        }

        PubSubTargetBuilder withPubSubEndpoint(String pubSubEndpoint) {
            this.pubSubEndpoint = pubSubEndpoint;
            return this;
        }

        GooglePubSubSenderTarget build() {
            return new GooglePubSubSenderTarget(this.topicName, this.pubSubEndpoint);
        }
    }
}

