/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender.googlepubsub;

import com.google.common.base.Preconditions;
import com.google.pubsub.v1.TopicName;
import java.net.URI;
import pl.allegro.tech.hermes.api.EndpointAddress;
import pl.allegro.tech.hermes.consumers.consumer.sender.googlepubsub.GooglePubSubSenderTarget;

public class GooglePubSubSenderTargetResolver {
    public GooglePubSubSenderTarget resolve(EndpointAddress address) {
        try {
            URI uri = URI.create(address.getRawEndpoint());
            Preconditions.checkArgument((boolean)uri.getScheme().equals("googlepubsub"));
            Preconditions.checkArgument((uri.getPort() > 0 ? 1 : 0) != 0);
            return GooglePubSubSenderTarget.builder().withPubSubEndpoint(uri.getAuthority()).withTopicName(TopicName.parse((String)uri.getPath().substring(1))).build();
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Given endpoint address is invalid", e);
        }
    }
}

