/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.workload.weighted;

import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.consumers.supervisor.workload.weighted.SubscriptionProfile;

class SubscriptionProfiles {
    static final SubscriptionProfiles EMPTY = new SubscriptionProfiles(Map.of(), null);
    private final Map<SubscriptionName, SubscriptionProfile> profiles;
    private Instant updateTimestamp;

    SubscriptionProfiles() {
        this(new HashMap<SubscriptionName, SubscriptionProfile>(), null);
    }

    SubscriptionProfiles(Map<SubscriptionName, SubscriptionProfile> profiles, Instant updateTimestamp) {
        this.profiles = profiles;
        this.updateTimestamp = updateTimestamp;
    }

    Instant getUpdateTimestamp() {
        return this.updateTimestamp;
    }

    Set<SubscriptionName> getSubscriptions() {
        return this.profiles.keySet();
    }

    SubscriptionProfile getProfile(SubscriptionName subscriptionName) {
        return this.profiles.get(subscriptionName);
    }

    SubscriptionProfile getProfileOrUndefined(SubscriptionName subscriptionName) {
        return this.profiles.getOrDefault(subscriptionName, SubscriptionProfile.UNDEFINED);
    }

    void updateProfile(SubscriptionName subscriptionName, SubscriptionProfile newProfile) {
        this.profiles.put(subscriptionName, newProfile);
    }

    void reset(Instant newUpdateTimestamp) {
        this.profiles.clear();
        this.updateTimestamp = newUpdateTimestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriptionProfiles that = (SubscriptionProfiles)o;
        return Objects.equals(this.profiles, that.profiles) && Objects.equals(this.toMillis(this.updateTimestamp), this.toMillis(that.updateTimestamp));
    }

    public int hashCode() {
        return Objects.hash(this.profiles, this.toMillis(this.updateTimestamp));
    }

    private Long toMillis(Instant timestamp) {
        if (timestamp == null) {
            return null;
        }
        return timestamp.toEpochMilli();
    }
}

