/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.workload.weighted;

import java.time.Instant;
import java.util.HashMap;
import java.util.Optional;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.consumers.subscription.id.SubscriptionId;
import pl.allegro.tech.hermes.consumers.subscription.id.SubscriptionIds;
import pl.allegro.tech.hermes.consumers.supervisor.workload.sbe.stubs.MessageHeaderDecoder;
import pl.allegro.tech.hermes.consumers.supervisor.workload.sbe.stubs.ProfilesDecoder;
import pl.allegro.tech.hermes.consumers.supervisor.workload.weighted.SubscriptionProfile;
import pl.allegro.tech.hermes.consumers.supervisor.workload.weighted.SubscriptionProfiles;
import pl.allegro.tech.hermes.consumers.supervisor.workload.weighted.Weight;

class SubscriptionProfilesDecoder {
    private static final Logger logger = LoggerFactory.getLogger(SubscriptionProfilesDecoder.class);
    private final SubscriptionIds subscriptionIds;

    SubscriptionProfilesDecoder(SubscriptionIds subscriptionIds) {
        this.subscriptionIds = subscriptionIds;
    }

    SubscriptionProfiles decode(byte[] bytes) {
        MessageHeaderDecoder header = new MessageHeaderDecoder();
        ProfilesDecoder body = new ProfilesDecoder();
        UnsafeBuffer buffer = new UnsafeBuffer(bytes);
        header.wrap((DirectBuffer)buffer, 0);
        if (header.schemaId() != 2 || header.templateId() != 3) {
            logger.warn("Unable to decode subscription profiles, schema or template id mismatch. Required by decoder: [schema id={}, template id={}], encoded in payload: [schema id={}, template id={}]", new Object[]{2, 3, header.schemaId(), header.templateId()});
            return SubscriptionProfiles.EMPTY;
        }
        body.wrap((DirectBuffer)buffer, header.encodedLength(), header.blockLength(), header.version());
        return this.decodeSubscriptionProfiles(body);
    }

    private SubscriptionProfiles decodeSubscriptionProfiles(ProfilesDecoder body) {
        Instant updateTimestamp = this.toInstant(body.updateTimestamp());
        HashMap<SubscriptionName, SubscriptionProfile> subscriptionProfiles = new HashMap<SubscriptionName, SubscriptionProfile>();
        for (ProfilesDecoder.SubscriptionsDecoder subscriptionsDecoder : body.subscriptions()) {
            long id = subscriptionsDecoder.id();
            Optional<SubscriptionId> subscriptionId = this.subscriptionIds.getSubscriptionId(id);
            if (!subscriptionId.isPresent()) continue;
            double operationsPerSecond = subscriptionsDecoder.operationsPerSecond();
            Instant lastRebalance = this.toInstant(subscriptionsDecoder.lastRebalanceTimestamp());
            SubscriptionProfile profile = new SubscriptionProfile(lastRebalance, new Weight(operationsPerSecond));
            subscriptionProfiles.put(subscriptionId.get().getSubscriptionName(), profile);
        }
        return new SubscriptionProfiles(subscriptionProfiles, updateTimestamp);
    }

    private Instant toInstant(long millis) {
        if (millis < 0L) {
            return null;
        }
        return Instant.ofEpochMilli(millis);
    }
}

