/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.config;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.time.Clock;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.curator.framework.CuratorFramework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import pl.allegro.tech.hermes.common.admin.zookeeper.ZookeeperAdminCache;
import pl.allegro.tech.hermes.common.concurrent.ExecutorServiceFactory;
import pl.allegro.tech.hermes.common.kafka.offset.SubscriptionOffsetChangeIndicator;
import pl.allegro.tech.hermes.common.message.wrapper.CompositeMessageContentWrapper;
import pl.allegro.tech.hermes.common.metric.HermesMetrics;
import pl.allegro.tech.hermes.consumers.config.CommitOffsetProperties;
import pl.allegro.tech.hermes.consumers.config.CommonConsumerProperties;
import pl.allegro.tech.hermes.consumers.config.KafkaClustersProperties;
import pl.allegro.tech.hermes.consumers.config.KafkaProperties;
import pl.allegro.tech.hermes.consumers.config.WorkloadProperties;
import pl.allegro.tech.hermes.consumers.consumer.ConsumerAuthorizationHandler;
import pl.allegro.tech.hermes.consumers.consumer.ConsumerMessageSenderFactory;
import pl.allegro.tech.hermes.consumers.consumer.batch.MessageBatchFactory;
import pl.allegro.tech.hermes.consumers.consumer.converter.MessageConverterResolver;
import pl.allegro.tech.hermes.consumers.consumer.load.SubscriptionLoadRecordersRegistry;
import pl.allegro.tech.hermes.consumers.consumer.offset.ConsumerPartitionAssignmentState;
import pl.allegro.tech.hermes.consumers.consumer.offset.OffsetQueue;
import pl.allegro.tech.hermes.consumers.consumer.rate.ConsumerRateLimitSupervisor;
import pl.allegro.tech.hermes.consumers.consumer.rate.calculator.OutputRateCalculatorFactory;
import pl.allegro.tech.hermes.consumers.consumer.receiver.ReceiverFactory;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageBatchSenderFactory;
import pl.allegro.tech.hermes.consumers.health.ConsumerMonitor;
import pl.allegro.tech.hermes.consumers.message.undelivered.UndeliveredMessageLogPersister;
import pl.allegro.tech.hermes.consumers.registry.ConsumerNodesRegistry;
import pl.allegro.tech.hermes.consumers.subscription.cache.SubscriptionsCache;
import pl.allegro.tech.hermes.consumers.subscription.id.SubscriptionIds;
import pl.allegro.tech.hermes.consumers.supervisor.ConsumerFactory;
import pl.allegro.tech.hermes.consumers.supervisor.ConsumersExecutorService;
import pl.allegro.tech.hermes.consumers.supervisor.ConsumersSupervisor;
import pl.allegro.tech.hermes.consumers.supervisor.NonblockingConsumersSupervisor;
import pl.allegro.tech.hermes.consumers.supervisor.monitor.ConsumersRuntimeMonitor;
import pl.allegro.tech.hermes.consumers.supervisor.process.Retransmitter;
import pl.allegro.tech.hermes.consumers.supervisor.workload.BalancingListener;
import pl.allegro.tech.hermes.consumers.supervisor.workload.ClusterAssignmentCache;
import pl.allegro.tech.hermes.consumers.supervisor.workload.ConsumerAssignmentCache;
import pl.allegro.tech.hermes.consumers.supervisor.workload.ConsumerAssignmentRegistry;
import pl.allegro.tech.hermes.consumers.supervisor.workload.WorkBalancer;
import pl.allegro.tech.hermes.consumers.supervisor.workload.WorkloadSupervisor;
import pl.allegro.tech.hermes.consumers.supervisor.workload.selective.SelectiveWorkBalancer;
import pl.allegro.tech.hermes.consumers.supervisor.workload.weighted.ConsumerNodeLoadRegistry;
import pl.allegro.tech.hermes.consumers.supervisor.workload.weighted.NoOpConsumerNodeLoadRegistry;
import pl.allegro.tech.hermes.consumers.supervisor.workload.weighted.NoOpSubscriptionProfileRegistry;
import pl.allegro.tech.hermes.consumers.supervisor.workload.weighted.SubscriptionProfileProvider;
import pl.allegro.tech.hermes.consumers.supervisor.workload.weighted.SubscriptionProfileRegistry;
import pl.allegro.tech.hermes.consumers.supervisor.workload.weighted.SubscriptionProfilesCalculator;
import pl.allegro.tech.hermes.consumers.supervisor.workload.weighted.WeightedWorkBalancer;
import pl.allegro.tech.hermes.consumers.supervisor.workload.weighted.ZookeeperConsumerNodeLoadRegistry;
import pl.allegro.tech.hermes.consumers.supervisor.workload.weighted.ZookeeperSubscriptionProfileRegistry;
import pl.allegro.tech.hermes.domain.notifications.InternalNotificationsBus;
import pl.allegro.tech.hermes.domain.subscription.SubscriptionRepository;
import pl.allegro.tech.hermes.domain.topic.TopicRepository;
import pl.allegro.tech.hermes.domain.workload.constraints.WorkloadConstraintsRepository;
import pl.allegro.tech.hermes.infrastructure.dc.DatacenterNameProvider;
import pl.allegro.tech.hermes.infrastructure.zookeeper.ZookeeperPaths;
import pl.allegro.tech.hermes.tracker.consumers.Trackers;

@Configuration
@EnableConfigurationProperties(value={CommitOffsetProperties.class, KafkaClustersProperties.class, WorkloadProperties.class, CommonConsumerProperties.class})
public class SupervisorConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(SupervisorConfiguration.class);

    @Bean(initMethod="start", destroyMethod="shutdown")
    public WorkloadSupervisor workloadSupervisor(InternalNotificationsBus notificationsBus, ConsumerNodesRegistry consumerNodesRegistry, ConsumerAssignmentRegistry assignmentRegistry, ConsumerAssignmentCache consumerAssignmentCache, ClusterAssignmentCache clusterAssignmentCache, SubscriptionsCache subscriptionsCache, ConsumersSupervisor supervisor, ZookeeperAdminCache adminCache, HermesMetrics metrics, WorkloadProperties workloadProperties, KafkaClustersProperties kafkaClustersProperties, WorkloadConstraintsRepository workloadConstraintsRepository, DatacenterNameProvider datacenterNameProvider, WorkBalancer workBalancer, BalancingListener balancingListener) {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("AssignmentExecutor-%d").setUncaughtExceptionHandler((t, e) -> logger.error("AssignmentExecutor failed {}", (Object)t.getName(), (Object)e)).build();
        ExecutorService assignmentExecutor = Executors.newFixedThreadPool(workloadProperties.getAssignmentProcessingThreadPoolSize(), threadFactory);
        KafkaProperties kafkaProperties = kafkaClustersProperties.toKafkaProperties(datacenterNameProvider);
        return new WorkloadSupervisor(supervisor, notificationsBus, subscriptionsCache, consumerAssignmentCache, assignmentRegistry, clusterAssignmentCache, consumerNodesRegistry, adminCache, assignmentExecutor, workloadProperties, kafkaProperties.getClusterName(), metrics, workloadConstraintsRepository, workBalancer, balancingListener);
    }

    @Bean
    public WorkBalancer workBalancer(WorkloadProperties workloadProperties, Clock clock, SubscriptionProfileProvider subscriptionProfileProvider) {
        switch (workloadProperties.getWorkBalancingStrategy()) {
            case SELECTIVE: {
                return new SelectiveWorkBalancer();
            }
            case WEIGHTED: {
                WorkloadProperties.WeightedWorkBalancingProperties weightedWorkBalancingProperties = workloadProperties.getWeightedWorkBalancing();
                return new WeightedWorkBalancer(clock, weightedWorkBalancingProperties.getStabilizationWindowSize(), weightedWorkBalancingProperties.getMinSignificantChangePercent(), subscriptionProfileProvider);
            }
        }
        throw new WorkloadProperties.WorkBalancingStrategy.UnknownWorkBalancingStrategyException();
    }

    @Bean(initMethod="start", destroyMethod="stop")
    public ConsumerNodeLoadRegistry consumerNodeLoadRegistry(CuratorFramework curator, SubscriptionIds subscriptionIds, ZookeeperPaths zookeeperPaths, WorkloadProperties workloadProperties, KafkaClustersProperties kafkaClustersProperties, DatacenterNameProvider datacenterNameProvider, ExecutorServiceFactory executorServiceFactory, Clock clock, HermesMetrics metrics) {
        switch (workloadProperties.getWorkBalancingStrategy()) {
            case SELECTIVE: {
                return new NoOpConsumerNodeLoadRegistry();
            }
            case WEIGHTED: {
                KafkaProperties kafkaProperties = kafkaClustersProperties.toKafkaProperties(datacenterNameProvider);
                WorkloadProperties.WeightedWorkBalancingProperties weightedWorkBalancing = workloadProperties.getWeightedWorkBalancing();
                return new ZookeeperConsumerNodeLoadRegistry(curator, subscriptionIds, zookeeperPaths, workloadProperties.getNodeId(), kafkaProperties.getClusterName(), weightedWorkBalancing.getLoadReportingInterval(), executorServiceFactory, clock, metrics, weightedWorkBalancing.getConsumerLoadEncoderBufferSizeBytes());
            }
        }
        throw new WorkloadProperties.WorkBalancingStrategy.UnknownWorkBalancingStrategyException();
    }

    @Bean
    public SubscriptionProfilesCalculator subscriptionProfilesCalculator(ConsumerNodeLoadRegistry consumerNodeLoadRegistry, SubscriptionProfileRegistry subscriptionProfileRegistry, WorkloadProperties workloadProperties, Clock clock) {
        return new SubscriptionProfilesCalculator(consumerNodeLoadRegistry, subscriptionProfileRegistry, clock, workloadProperties.getWeightedWorkBalancing().getWeightWindowSize());
    }

    @Bean
    public SubscriptionProfileRegistry subscriptionProfileRegistry(CuratorFramework curator, SubscriptionIds subscriptionIds, ZookeeperPaths zookeeperPaths, WorkloadProperties workloadProperties, KafkaClustersProperties kafkaClustersProperties, DatacenterNameProvider datacenterNameProvider) {
        switch (workloadProperties.getWorkBalancingStrategy()) {
            case SELECTIVE: {
                return new NoOpSubscriptionProfileRegistry();
            }
            case WEIGHTED: {
                KafkaProperties kafkaProperties = kafkaClustersProperties.toKafkaProperties(datacenterNameProvider);
                WorkloadProperties.WeightedWorkBalancingProperties weightedWorkBalancing = workloadProperties.getWeightedWorkBalancing();
                return new ZookeeperSubscriptionProfileRegistry(curator, subscriptionIds, zookeeperPaths, kafkaProperties.getClusterName(), weightedWorkBalancing.getSubscriptionProfilesEncoderBufferSizeBytes());
            }
        }
        throw new WorkloadProperties.WorkBalancingStrategy.UnknownWorkBalancingStrategyException();
    }

    @Bean
    public Retransmitter retransmitter(SubscriptionOffsetChangeIndicator subscriptionOffsetChangeIndicator, KafkaClustersProperties kafkaClustersProperties, DatacenterNameProvider datacenterNameProvider) {
        KafkaProperties kafkaProperties = kafkaClustersProperties.toKafkaProperties(datacenterNameProvider);
        return new Retransmitter(subscriptionOffsetChangeIndicator, kafkaProperties.getClusterName());
    }

    @Bean
    public ConsumerFactory consumerFactory(ReceiverFactory messageReceiverFactory, HermesMetrics hermesMetrics, CommonConsumerProperties commonConsumerProperties, ConsumerRateLimitSupervisor consumerRateLimitSupervisor, OutputRateCalculatorFactory outputRateCalculatorFactory, Trackers trackers, OffsetQueue offsetQueue, ConsumerMessageSenderFactory consumerMessageSenderFactory, TopicRepository topicRepository, MessageConverterResolver messageConverterResolver, MessageBatchFactory byteBufferMessageBatchFactory, CompositeMessageContentWrapper compositeMessageContentWrapper, MessageBatchSenderFactory batchSenderFactory, ConsumerAuthorizationHandler consumerAuthorizationHandler, Clock clock, SubscriptionLoadRecordersRegistry subscriptionLoadRecordersRegistry) {
        return new ConsumerFactory(messageReceiverFactory, hermesMetrics, commonConsumerProperties, consumerRateLimitSupervisor, outputRateCalculatorFactory, trackers, offsetQueue, consumerMessageSenderFactory, topicRepository, messageConverterResolver, byteBufferMessageBatchFactory, compositeMessageContentWrapper, batchSenderFactory, consumerAuthorizationHandler, clock, subscriptionLoadRecordersRegistry);
    }

    @Bean
    public ConsumersExecutorService consumersExecutorService(CommonConsumerProperties commonConsumerProperties, HermesMetrics hermesMetrics) {
        return new ConsumersExecutorService(commonConsumerProperties.getThreadPoolSize(), hermesMetrics);
    }

    @Bean
    public ConsumersSupervisor nonblockingConsumersSupervisor(CommonConsumerProperties commonConsumerProperties, ConsumersExecutorService executor, ConsumerFactory consumerFactory, OffsetQueue offsetQueue, ConsumerPartitionAssignmentState consumerPartitionAssignmentState, Retransmitter retransmitter, UndeliveredMessageLogPersister undeliveredMessageLogPersister, SubscriptionRepository subscriptionRepository, HermesMetrics metrics, ConsumerMonitor monitor, Clock clock, CommitOffsetProperties commitOffsetProperties) {
        return new NonblockingConsumersSupervisor(commonConsumerProperties, executor, consumerFactory, offsetQueue, consumerPartitionAssignmentState, retransmitter, undeliveredMessageLogPersister, subscriptionRepository, metrics, monitor, clock, commitOffsetProperties.getPeriod());
    }

    @Bean(initMethod="start", destroyMethod="shutdown")
    public ConsumersRuntimeMonitor consumersRuntimeMonitor(ConsumersSupervisor consumerSupervisor, WorkloadSupervisor workloadSupervisor, HermesMetrics hermesMetrics, SubscriptionsCache subscriptionsCache, WorkloadProperties workloadProperties) {
        return new ConsumersRuntimeMonitor(consumerSupervisor, workloadSupervisor, hermesMetrics, subscriptionsCache, workloadProperties.getMonitorScanInterval());
    }

    @Bean
    public ConsumerAssignmentRegistry consumerAssignmentRegistry(CuratorFramework curator, WorkloadProperties workloadProperties, KafkaClustersProperties kafkaClustersProperties, ZookeeperPaths zookeeperPaths, SubscriptionIds subscriptionIds, DatacenterNameProvider datacenterNameProvider) {
        KafkaProperties kafkaProperties = kafkaClustersProperties.toKafkaProperties(datacenterNameProvider);
        return new ConsumerAssignmentRegistry(curator, workloadProperties.getRegistryBinaryEncoderAssignmentsBufferSizeBytes(), kafkaProperties.getClusterName(), zookeeperPaths, subscriptionIds);
    }

    @Bean
    public ClusterAssignmentCache clusterAssignmentCache(CuratorFramework curator, KafkaClustersProperties kafkaClustersProperties, ZookeeperPaths zookeeperPaths, SubscriptionIds subscriptionIds, ConsumerNodesRegistry consumerNodesRegistry, DatacenterNameProvider datacenterNameProvider) {
        KafkaProperties kafkaProperties = kafkaClustersProperties.toKafkaProperties(datacenterNameProvider);
        return new ClusterAssignmentCache(curator, kafkaProperties.getClusterName(), zookeeperPaths, subscriptionIds, consumerNodesRegistry);
    }

    @Bean(initMethod="start", destroyMethod="stop")
    public ConsumerAssignmentCache consumerAssignmentCache(CuratorFramework curator, WorkloadProperties workloadProperties, KafkaClustersProperties kafkaClustersProperties, ZookeeperPaths zookeeperPaths, SubscriptionIds subscriptionIds, DatacenterNameProvider datacenterNameProvider) {
        KafkaProperties kafkaProperties = kafkaClustersProperties.toKafkaProperties(datacenterNameProvider);
        return new ConsumerAssignmentCache(curator, workloadProperties.getNodeId(), kafkaProperties.getClusterName(), zookeeperPaths, subscriptionIds);
    }
}

