/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.config;

import java.time.Duration;
import java.util.Arrays;
import java.util.UUID;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import pl.allegro.tech.hermes.common.exception.InternalProcessingException;
import pl.allegro.tech.hermes.common.util.InetAddressInstanceIdResolver;
import pl.allegro.tech.hermes.consumers.supervisor.workload.WorkBalancingParameters;

@ConfigurationProperties(prefix="consumer.workload")
public class WorkloadProperties
implements WorkBalancingParameters {
    private int registryBinaryEncoderAssignmentsBufferSizeBytes = 100000;
    private Duration rebalanceInterval = Duration.ofSeconds(30L);
    private int consumersPerSubscription = 2;
    private int maxSubscriptionsPerConsumer = 200;
    private int assignmentProcessingThreadPoolSize = 5;
    private String nodeId = new InetAddressInstanceIdResolver().resolve().replaceAll("\\.", "_") + "$" + Math.abs(UUID.randomUUID().getMostSignificantBits());
    private Duration monitorScanInterval = Duration.ofSeconds(120L);
    private boolean autoRebalance = true;
    private Duration deadAfter = Duration.ofSeconds(120L);
    private WorkBalancingStrategy workBalancingStrategy = WorkBalancingStrategy.SELECTIVE;
    @NestedConfigurationProperty
    private WeightedWorkBalancingProperties weightedWorkBalancing = new WeightedWorkBalancingProperties();

    public int getRegistryBinaryEncoderAssignmentsBufferSizeBytes() {
        return this.registryBinaryEncoderAssignmentsBufferSizeBytes;
    }

    public void setRegistryBinaryEncoderAssignmentsBufferSizeBytes(int registryBinaryEncoderAssignmentsBufferSizeBytes) {
        this.registryBinaryEncoderAssignmentsBufferSizeBytes = registryBinaryEncoderAssignmentsBufferSizeBytes;
    }

    @Override
    public Duration getRebalanceInterval() {
        return this.rebalanceInterval;
    }

    public void setRebalanceInterval(Duration rebalanceInterval) {
        this.rebalanceInterval = rebalanceInterval;
    }

    @Override
    public int getConsumersPerSubscription() {
        return this.consumersPerSubscription;
    }

    public void setConsumersPerSubscription(int consumersPerSubscription) {
        this.consumersPerSubscription = consumersPerSubscription;
    }

    @Override
    public int getMaxSubscriptionsPerConsumer() {
        return this.maxSubscriptionsPerConsumer;
    }

    public void setMaxSubscriptionsPerConsumer(int maxSubscriptionsPerConsumer) {
        this.maxSubscriptionsPerConsumer = maxSubscriptionsPerConsumer;
    }

    public int getAssignmentProcessingThreadPoolSize() {
        return this.assignmentProcessingThreadPoolSize;
    }

    public void setAssignmentProcessingThreadPoolSize(int assignmentProcessingThreadPoolSize) {
        this.assignmentProcessingThreadPoolSize = assignmentProcessingThreadPoolSize;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public Duration getMonitorScanInterval() {
        return this.monitorScanInterval;
    }

    public void setMonitorScanInterval(Duration monitorScanInterval) {
        this.monitorScanInterval = monitorScanInterval;
    }

    @Override
    public boolean isAutoRebalance() {
        return this.autoRebalance;
    }

    public void setAutoRebalance(boolean autoRebalance) {
        this.autoRebalance = autoRebalance;
    }

    public Duration getDeadAfter() {
        return this.deadAfter;
    }

    public void setDeadAfter(Duration deadAfter) {
        this.deadAfter = deadAfter;
    }

    public WorkBalancingStrategy getWorkBalancingStrategy() {
        return this.workBalancingStrategy;
    }

    public void setWorkBalancingStrategy(WorkBalancingStrategy workBalancingStrategy) {
        this.workBalancingStrategy = workBalancingStrategy;
    }

    public WeightedWorkBalancingProperties getWeightedWorkBalancing() {
        return this.weightedWorkBalancing;
    }

    public void setWeightedWorkBalancing(WeightedWorkBalancingProperties weightedWorkBalancing) {
        this.weightedWorkBalancing = weightedWorkBalancing;
    }

    public static enum WorkBalancingStrategy {
        SELECTIVE,
        WEIGHTED;


        public static class UnknownWorkBalancingStrategyException
        extends InternalProcessingException {
            public UnknownWorkBalancingStrategyException() {
                super("Unknown work balancing strategy. Use one of: " + Arrays.toString((Object[])WorkBalancingStrategy.values()));
            }
        }
    }

    public static class WeightedWorkBalancingProperties {
        private int consumerLoadEncoderBufferSizeBytes = 100000;
        private int subscriptionProfilesEncoderBufferSizeBytes = 100000;
        private Duration loadReportingInterval = Duration.ofMinutes(1L);
        private Duration stabilizationWindowSize = Duration.ofMinutes(30L);
        private double minSignificantChangePercent = 5.0;
        private Duration weightWindowSize = Duration.ofMinutes(15L);

        public int getConsumerLoadEncoderBufferSizeBytes() {
            return this.consumerLoadEncoderBufferSizeBytes;
        }

        public void setConsumerLoadEncoderBufferSizeBytes(int consumerLoadEncoderBufferSizeBytes) {
            this.consumerLoadEncoderBufferSizeBytes = consumerLoadEncoderBufferSizeBytes;
        }

        public int getSubscriptionProfilesEncoderBufferSizeBytes() {
            return this.subscriptionProfilesEncoderBufferSizeBytes;
        }

        public void setSubscriptionProfilesEncoderBufferSizeBytes(int subscriptionProfilesEncoderBufferSizeBytes) {
            this.subscriptionProfilesEncoderBufferSizeBytes = subscriptionProfilesEncoderBufferSizeBytes;
        }

        public Duration getLoadReportingInterval() {
            return this.loadReportingInterval;
        }

        public void setLoadReportingInterval(Duration loadReportingInterval) {
            this.loadReportingInterval = loadReportingInterval;
        }

        public Duration getStabilizationWindowSize() {
            return this.stabilizationWindowSize;
        }

        public void setStabilizationWindowSize(Duration stabilizationWindowSize) {
            this.stabilizationWindowSize = stabilizationWindowSize;
        }

        public double getMinSignificantChangePercent() {
            return this.minSignificantChangePercent;
        }

        public void setMinSignificantChangePercent(double minSignificantChangePercent) {
            this.minSignificantChangePercent = minSignificantChangePercent;
        }

        public Duration getWeightWindowSize() {
            return this.weightWindowSize;
        }

        public void setWeightWindowSize(Duration weightWindowSize) {
            this.weightWindowSize = weightWindowSize;
        }
    }
}

