/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.oauth;

import com.codahale.metrics.Timer;
import com.google.common.cache.CacheLoader;
import pl.allegro.tech.hermes.api.OAuthProvider;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.api.SubscriptionOAuthPolicy;
import pl.allegro.tech.hermes.common.metric.HermesMetrics;
import pl.allegro.tech.hermes.consumers.consumer.oauth.OAuthAccessToken;
import pl.allegro.tech.hermes.consumers.consumer.oauth.client.OAuthClient;
import pl.allegro.tech.hermes.consumers.consumer.oauth.client.OAuthTokenRequest;
import pl.allegro.tech.hermes.domain.oauth.OAuthProviderRepository;
import pl.allegro.tech.hermes.domain.subscription.SubscriptionRepository;

public class OAuthAccessTokensLoader
extends CacheLoader<SubscriptionName, OAuthAccessToken> {
    private final SubscriptionRepository subscriptionRepository;
    private final OAuthProviderRepository oAuthProviderRepository;
    private final OAuthClient oAuthClient;
    private final HermesMetrics metrics;

    public OAuthAccessTokensLoader(SubscriptionRepository subscriptionRepository, OAuthProviderRepository oAuthProviderRepository, OAuthClient oAuthClient, HermesMetrics metrics) {
        this.subscriptionRepository = subscriptionRepository;
        this.oAuthProviderRepository = oAuthProviderRepository;
        this.oAuthClient = oAuthClient;
        this.metrics = metrics;
    }

    public OAuthAccessToken load(SubscriptionName subscriptionName) throws Exception {
        Subscription subscription = this.subscriptionRepository.getSubscriptionDetails(subscriptionName);
        SubscriptionOAuthPolicy oAuthPolicy = subscription.getOAuthPolicy();
        String providerName = oAuthPolicy.getProviderName();
        OAuthProvider oAuthProvider = this.oAuthProviderRepository.getOAuthProviderDetails(providerName);
        OAuthTokenRequest request = SubscriptionOAuthPolicy.GrantType.USERNAME_PASSWORD.equals((Object)oAuthPolicy.getGrantType()) ? this.getOAuthUsernamePasswordGrantTokenRequest(oAuthPolicy, oAuthProvider) : this.getOAuthClientCredentialsGrantTokenRequest(oAuthPolicy, oAuthProvider);
        this.metrics.oAuthSubscriptionTokenRequestMeter(subscription, providerName).mark();
        try (Timer.Context timer = this.metrics.oAuthProviderLatencyTimer(providerName).time();){
            OAuthAccessToken oAuthAccessToken = this.oAuthClient.getToken(request);
            return oAuthAccessToken;
        }
    }

    private OAuthTokenRequest getOAuthUsernamePasswordGrantTokenRequest(SubscriptionOAuthPolicy policy, OAuthProvider provider) {
        return OAuthTokenRequest.oAuthTokenRequest().withUrl(provider.getTokenEndpoint()).withGrantType("password").withScope(policy.getScope()).withClientId(provider.getClientId()).withClientSecret(provider.getClientSecret()).withUsername(policy.getUsername()).withPassword(policy.getPassword()).withRequestTimeout(provider.getRequestTimeout()).withSocketTimeout(provider.getSocketTimeout()).build();
    }

    private OAuthTokenRequest getOAuthClientCredentialsGrantTokenRequest(SubscriptionOAuthPolicy policy, OAuthProvider provider) {
        return OAuthTokenRequest.oAuthTokenRequest().withUrl(provider.getTokenEndpoint()).withGrantType("client_credentials").withScope(policy.getScope()).withClientId(provider.getClientId()).withClientSecret(provider.getClientSecret()).withRequestTimeout(provider.getRequestTimeout()).withSocketTimeout(provider.getSocketTimeout()).build();
    }
}

