/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.message.undelivered;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.time.Duration;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import pl.allegro.tech.hermes.common.message.undelivered.UndeliveredMessageLog;

public class UndeliveredMessageLogPersister {
    private final Duration period;
    private final UndeliveredMessageLog undeliveredMessageLog;
    private final ScheduledExecutorService scheduledExecutorService;

    public UndeliveredMessageLogPersister(UndeliveredMessageLog undeliveredMessageLog, Duration undeliveredMessageLogPersistPeriod) {
        this.undeliveredMessageLog = undeliveredMessageLog;
        this.period = undeliveredMessageLogPersistPeriod;
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("undelivered-message-log-persister-%d").build());
    }

    public void start() {
        this.scheduledExecutorService.scheduleAtFixedRate(() -> ((UndeliveredMessageLog)this.undeliveredMessageLog).persist(), this.period.toMillis(), this.period.toMillis(), TimeUnit.MILLISECONDS);
    }

    public void shutdown() {
        this.scheduledExecutorService.shutdown();
    }
}

