/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.workload.sbe.stubs;

import java.nio.ByteOrder;
import java.util.NoSuchElementException;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import pl.allegro.tech.hermes.consumers.supervisor.workload.sbe.stubs.ConsumerLoadDecoder;
import pl.allegro.tech.hermes.consumers.supervisor.workload.sbe.stubs.MessageHeaderEncoder;
import pl.allegro.tech.hermes.consumers.supervisor.workload.sbe.stubs.MetaAttribute;

public class ConsumerLoadEncoder {
    public static final int BLOCK_LENGTH = 0;
    public static final int TEMPLATE_ID = 2;
    public static final int SCHEMA_ID = 2;
    public static final int SCHEMA_VERSION = 0;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final ConsumerLoadEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    protected int offset;
    protected int limit;
    private final SubscriptionsEncoder subscriptions = new SubscriptionsEncoder(this);

    public int sbeBlockLength() {
        return 0;
    }

    public int sbeTemplateId() {
        return 2;
    }

    public int sbeSchemaId() {
        return 2;
    }

    public int sbeSchemaVersion() {
        return 0;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public ConsumerLoadEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.limit(offset + 0);
        return this;
    }

    public ConsumerLoadEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(0).templateId(2).schemaId(2).version(0);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static long subscriptionsId() {
        return 1L;
    }

    public SubscriptionsEncoder subscriptionsCount(int count) {
        this.subscriptions.wrap(this.buffer, count);
        return this.subscriptions;
    }

    public String toString() {
        return this.appendTo(new StringBuilder(100)).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        ConsumerLoadDecoder writer = new ConsumerLoadDecoder();
        writer.wrap((DirectBuffer)this.buffer, this.offset, 0, 0);
        return writer.appendTo(builder);
    }

    public static class SubscriptionsEncoder {
        public static final int HEADER_SIZE = 4;
        private final ConsumerLoadEncoder parentMessage;
        private MutableDirectBuffer buffer;
        private int count;
        private int index;
        private int offset;

        SubscriptionsEncoder(ConsumerLoadEncoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(MutableDirectBuffer buffer, int count) {
            if (count < 0 || count > 65534) {
                throw new IllegalArgumentException("count outside allowed range: count=" + count);
            }
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = -1;
            this.count = count;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4);
            buffer.putShort(limit + 0, (short)16, ByteOrder.LITTLE_ENDIAN);
            buffer.putShort(limit + 2, (short)count, ByteOrder.LITTLE_ENDIAN);
        }

        public static int sbeHeaderSize() {
            return 4;
        }

        public static int sbeBlockLength() {
            return 16;
        }

        public SubscriptionsEncoder next() {
            if (this.index + 1 >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + SubscriptionsEncoder.sbeBlockLength());
            ++this.index;
            return this;
        }

        public static int idId() {
            return 2;
        }

        public static int idSinceVersion() {
            return 0;
        }

        public static int idEncodingOffset() {
            return 0;
        }

        public static int idEncodingLength() {
            return 8;
        }

        public static String idMetaAttribute(MetaAttribute metaAttribute) {
            switch (metaAttribute) {
                case EPOCH: {
                    return "";
                }
                case TIME_UNIT: {
                    return "";
                }
                case SEMANTIC_TYPE: {
                    return "";
                }
                case PRESENCE: {
                    return "required";
                }
            }
            return "";
        }

        public static long idNullValue() {
            return Long.MIN_VALUE;
        }

        public static long idMinValue() {
            return -9223372036854775807L;
        }

        public static long idMaxValue() {
            return Long.MAX_VALUE;
        }

        public SubscriptionsEncoder id(long value) {
            this.buffer.putLong(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
            return this;
        }

        public static int operationsPerSecondId() {
            return 3;
        }

        public static int operationsPerSecondSinceVersion() {
            return 0;
        }

        public static int operationsPerSecondEncodingOffset() {
            return 8;
        }

        public static int operationsPerSecondEncodingLength() {
            return 8;
        }

        public static String operationsPerSecondMetaAttribute(MetaAttribute metaAttribute) {
            switch (metaAttribute) {
                case EPOCH: {
                    return "";
                }
                case TIME_UNIT: {
                    return "";
                }
                case SEMANTIC_TYPE: {
                    return "";
                }
                case PRESENCE: {
                    return "required";
                }
            }
            return "";
        }

        public static double operationsPerSecondNullValue() {
            return Double.NaN;
        }

        public static double operationsPerSecondMinValue() {
            return Double.MIN_VALUE;
        }

        public static double operationsPerSecondMaxValue() {
            return Double.MAX_VALUE;
        }

        public SubscriptionsEncoder operationsPerSecond(double value) {
            this.buffer.putDouble(this.offset + 8, value, ByteOrder.LITTLE_ENDIAN);
            return this;
        }
    }
}

