/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.workload.weighted;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.agrona.ExpandableDirectByteBuffer;
import org.agrona.MutableDirectBuffer;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.consumers.subscription.id.SubscriptionId;
import pl.allegro.tech.hermes.consumers.subscription.id.SubscriptionIds;
import pl.allegro.tech.hermes.consumers.supervisor.workload.sbe.stubs.ConsumerLoadEncoder;
import pl.allegro.tech.hermes.consumers.supervisor.workload.sbe.stubs.MessageHeaderEncoder;
import pl.allegro.tech.hermes.consumers.supervisor.workload.weighted.ConsumerNodeLoad;
import pl.allegro.tech.hermes.consumers.supervisor.workload.weighted.SubscriptionLoad;

class ConsumerNodeLoadEncoder {
    private final SubscriptionIds subscriptionIds;
    private final MutableDirectBuffer buffer;

    ConsumerNodeLoadEncoder(SubscriptionIds subscriptionIds, int bufferSize) {
        this.subscriptionIds = subscriptionIds;
        this.buffer = new ExpandableDirectByteBuffer(bufferSize);
    }

    byte[] encode(ConsumerNodeLoad metrics) {
        Map<SubscriptionId, SubscriptionLoad> subscriptionLoads = this.mapToSubscriptionIds(metrics);
        MessageHeaderEncoder headerEncoder = new MessageHeaderEncoder();
        ConsumerLoadEncoder body = new ConsumerLoadEncoder().wrapAndApplyHeader(this.buffer, 0, headerEncoder);
        ConsumerLoadEncoder.SubscriptionsEncoder loadPerSubscriptionEncoder = body.subscriptionsCount(subscriptionLoads.size());
        for (Map.Entry<SubscriptionId, SubscriptionLoad> entry : subscriptionLoads.entrySet()) {
            SubscriptionId subscriptionId = entry.getKey();
            SubscriptionLoad load = entry.getValue();
            loadPerSubscriptionEncoder.next().id(subscriptionId.getValue()).operationsPerSecond(load.getOperationsPerSecond());
        }
        int len = headerEncoder.encodedLength() + body.encodedLength();
        byte[] dst = new byte[len];
        this.buffer.getBytes(0, dst);
        return dst;
    }

    private Map<SubscriptionId, SubscriptionLoad> mapToSubscriptionIds(ConsumerNodeLoad metrics) {
        HashMap<SubscriptionId, SubscriptionLoad> subscriptionLoads = new HashMap<SubscriptionId, SubscriptionLoad>();
        for (Map.Entry<SubscriptionName, SubscriptionLoad> entry : metrics.getLoadPerSubscription().entrySet()) {
            Optional<SubscriptionId> subscriptionId = this.subscriptionIds.getSubscriptionId(entry.getKey());
            subscriptionId.ifPresent(id -> subscriptionLoads.put((SubscriptionId)id, (SubscriptionLoad)entry.getValue()));
        }
        return subscriptionLoads;
    }
}

