/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.workload.weighted;

import java.time.Instant;
import java.util.Objects;
import pl.allegro.tech.hermes.consumers.supervisor.workload.weighted.Weight;

class SubscriptionProfile {
    static SubscriptionProfile UNDEFINED = new SubscriptionProfile(null, Weight.ZERO);
    private final Instant lastRebalanceTimestamp;
    private final Weight weight;

    SubscriptionProfile(Instant lastRebalanceTimestamp, Weight weight) {
        this.lastRebalanceTimestamp = lastRebalanceTimestamp;
        this.weight = weight;
    }

    Weight getWeight() {
        return this.weight;
    }

    Instant getLastRebalanceTimestamp() {
        return this.lastRebalanceTimestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriptionProfile profile = (SubscriptionProfile)o;
        return Objects.equals(this.weight, profile.weight) && Objects.equals(this.toMillis(this.lastRebalanceTimestamp), this.toMillis(profile.lastRebalanceTimestamp));
    }

    public int hashCode() {
        return Objects.hash(this.toMillis(this.lastRebalanceTimestamp), this.weight);
    }

    private Long toMillis(Instant timestamp) {
        if (timestamp == null) {
            return null;
        }
        return timestamp.toEpochMilli();
    }
}

