/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.workload.weighted;

import com.google.common.base.Preconditions;
import java.util.Objects;

class Weight
implements Comparable<Weight> {
    static final Weight ZERO = new Weight(0.0);
    private final double operationsPerSecond;

    Weight(double operationsPerSecond) {
        Preconditions.checkArgument((operationsPerSecond >= 0.0 ? 1 : 0) != 0, (Object)"operationsPerSecond should be greater than or equal to zero");
        this.operationsPerSecond = operationsPerSecond;
    }

    static double calculatePercentageChange(Weight initialWeight, Weight finalWeight) {
        Preconditions.checkArgument((initialWeight.operationsPerSecond > 0.0 ? 1 : 0) != 0, (Object)"initialWeight.operationsPerSecond should be greater than zero");
        double delta = Math.abs(finalWeight.operationsPerSecond - initialWeight.operationsPerSecond);
        return delta / initialWeight.operationsPerSecond * 100.0;
    }

    static Weight max(Weight first, Weight second) {
        if (first.operationsPerSecond > second.operationsPerSecond) {
            return first;
        }
        return second;
    }

    Weight add(Weight addend) {
        return new Weight(this.operationsPerSecond + addend.operationsPerSecond);
    }

    Weight subtract(Weight subtrahend) {
        return new Weight(Math.max(this.operationsPerSecond - subtrahend.operationsPerSecond, 0.0));
    }

    Weight multiply(double multiplicand) {
        return new Weight(this.operationsPerSecond * multiplicand);
    }

    Weight divide(int divisor) {
        return new Weight(this.operationsPerSecond / (double)divisor);
    }

    boolean isGreaterThan(Weight other) {
        return this.operationsPerSecond > other.operationsPerSecond;
    }

    boolean isGreaterThanOrEqualTo(Weight other) {
        return this.isGreaterThan(other) || this.isEqualTo(other);
    }

    boolean isLessThan(Weight other) {
        return this.operationsPerSecond < other.operationsPerSecond;
    }

    boolean isEqualTo(Weight other) {
        return Double.compare(this.operationsPerSecond, other.operationsPerSecond) == 0;
    }

    double getOperationsPerSecond() {
        return this.operationsPerSecond;
    }

    @Override
    public int compareTo(Weight o) {
        return Double.compare(this.operationsPerSecond, o.operationsPerSecond);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Weight weight = (Weight)o;
        return Double.compare(weight.operationsPerSecond, this.operationsPerSecond) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.operationsPerSecond);
    }

    public String toString() {
        return "(ops=" + this.operationsPerSecond + ")";
    }
}

