/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender.http;

import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import pl.allegro.tech.hermes.api.EndpointAddress;
import pl.allegro.tech.hermes.api.EndpointAddressResolverMetadata;
import pl.allegro.tech.hermes.common.http.MessageMetadataHeaders;
import pl.allegro.tech.hermes.consumers.consumer.batch.MessageBatch;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageBatchSender;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageSendingResult;
import pl.allegro.tech.hermes.consumers.consumer.sender.SingleMessageSendingResult;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.ByteBufferEntity;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.SendingResultHandlers;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.headers.BatchHttpHeadersProvider;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.headers.HttpRequestHeaders;
import pl.allegro.tech.hermes.consumers.consumer.sender.resolver.EndpointAddressResolutionException;
import pl.allegro.tech.hermes.consumers.consumer.sender.resolver.EndpointAddressResolver;

public class ApacheHttpClientMessageBatchSender
implements MessageBatchSender {
    private final Duration connectionTimeout;
    private final Duration connectionRequestTimeout;
    private final EndpointAddressResolver resolver;
    private final SendingResultHandlers resultHandlers;
    private final BatchHttpHeadersProvider headersProvider;
    private final CloseableHttpClient client = HttpClients.createMinimal();

    public ApacheHttpClientMessageBatchSender(Duration connectionTimeout, Duration connectionRequestTimeout, EndpointAddressResolver resolver, SendingResultHandlers resultHandlers, BatchHttpHeadersProvider headersProvider) {
        this.connectionTimeout = connectionTimeout;
        this.connectionRequestTimeout = connectionRequestTimeout;
        this.resolver = resolver;
        this.resultHandlers = resultHandlers;
        this.headersProvider = headersProvider;
    }

    @Override
    public MessageSendingResult send(MessageBatch batch, EndpointAddress address, EndpointAddressResolverMetadata metadata, int requestTimeout) {
        try {
            HttpRequestHeaders headers = this.headersProvider.getHeaders(address);
            return this.send(batch, this.resolver.resolve(address, batch, metadata), requestTimeout, headers);
        }
        catch (EndpointAddressResolutionException e) {
            return MessageSendingResult.failedResult(e);
        }
    }

    public MessageSendingResult send(MessageBatch batch, URI address, int requestTimeout, HttpRequestHeaders headers) {
        ContentType contentType = this.getMediaType(batch.getContentType());
        HttpPost httpPost = new HttpPost(address);
        ByteBufferEntity entity = new ByteBufferEntity(batch.getContent(), contentType);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout((int)this.connectionTimeout.toMillis()).setConnectionRequestTimeout((int)this.connectionRequestTimeout.toMillis()).setSocketTimeout(requestTimeout).build();
        httpPost.setConfig(requestConfig);
        httpPost.setEntity((HttpEntity)entity);
        headers.asMap().forEach((arg_0, arg_1) -> ((HttpPost)httpPost).addHeader(arg_0, arg_1));
        httpPost.addHeader("Keep-Alive", "true");
        httpPost.addHeader(MessageMetadataHeaders.BATCH_ID.getName(), batch.getId());
        httpPost.addHeader("Content-Type", contentType.getMimeType());
        httpPost.addHeader(MessageMetadataHeaders.RETRY_COUNT.getName(), Integer.toString(batch.getRetryCounter()));
        if (batch.hasSubscriptionIdentityHeaders()) {
            httpPost.addHeader(MessageMetadataHeaders.TOPIC_NAME.getName(), batch.getTopic());
            httpPost.addHeader(MessageMetadataHeaders.SUBSCRIPTION_NAME.getName(), batch.getSubscription().getName());
        }
        batch.getAdditionalHeaders().forEach(header -> httpPost.addHeader(header.getName(), header.getValue()));
        return this.send(httpPost);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MessageSendingResult send(HttpPost post) {
        try {
            MessageSendingResult messageSendingResult = this.resultHandlers.handleSendingResultForBatch(this.client.execute((HttpUriRequest)post));
            return messageSendingResult;
        }
        catch (IOException e) {
            SingleMessageSendingResult singleMessageSendingResult = MessageSendingResult.failedResult(e);
            return singleMessageSendingResult;
        }
        finally {
            post.releaseConnection();
        }
    }

    public ContentType getMediaType(pl.allegro.tech.hermes.api.ContentType contentType) {
        return pl.allegro.tech.hermes.api.ContentType.AVRO.equals((Object)contentType) ? ContentType.create((String)"avro/binary") : ContentType.APPLICATION_JSON;
    }
}

