/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender;

import com.google.common.base.Preconditions;
import java.time.Duration;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageBatchSender;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageBatchSenderFactory;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.ApacheHttpClientMessageBatchSender;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.SendingResultHandlers;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.headers.DefaultBatchHeadersProvider;
import pl.allegro.tech.hermes.consumers.consumer.sender.resolver.SimpleEndpointAddressResolver;

public class HttpMessageBatchSenderFactory
implements MessageBatchSenderFactory {
    private final SendingResultHandlers resultHandlers;
    private final Duration connectionTimeout;
    private final Duration connectionRequestTimeout;

    public HttpMessageBatchSenderFactory(SendingResultHandlers resultHandlers, Duration connectionTimeout, Duration connectionRequestTimeout) {
        this.resultHandlers = resultHandlers;
        this.connectionTimeout = connectionTimeout;
        this.connectionRequestTimeout = connectionRequestTimeout;
    }

    @Override
    public MessageBatchSender create(Subscription subscription) {
        Preconditions.checkState((boolean)subscription.getEndpoint().getProtocol().contains("http"), (Object)"Batching is only supported for http/s currently.");
        return new ApacheHttpClientMessageBatchSender(this.connectionTimeout, this.connectionRequestTimeout, new SimpleEndpointAddressResolver(), this.resultHandlers, new DefaultBatchHeadersProvider());
    }
}

