/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender.http;

import java.net.CookieStore;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.http2.client.HTTP2Client;
import org.eclipse.jetty.http2.client.http.HttpClientTransportOverHTTP2;
import org.eclipse.jetty.util.HttpCookieStore;
import pl.allegro.tech.hermes.common.metric.executor.InstrumentedExecutorServiceFactory;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.Http2ClientParameters;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.HttpClientParameters;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.SslContextFactoryProvider;

public class HttpClientsFactory {
    private final HttpClientParameters httpClientParameters;
    private final Http2ClientParameters http2ClientParameters;
    private final InstrumentedExecutorServiceFactory executorFactory;
    private final SslContextFactoryProvider sslContextFactoryProvider;

    public HttpClientsFactory(HttpClientParameters httpClientParameters, Http2ClientParameters http2ClientParameters, InstrumentedExecutorServiceFactory executorFactory, SslContextFactoryProvider sslContextFactoryProvider) {
        this.httpClientParameters = httpClientParameters;
        this.http2ClientParameters = http2ClientParameters;
        this.executorFactory = executorFactory;
        this.sslContextFactoryProvider = sslContextFactoryProvider;
    }

    public HttpClient createClientForHttp1(String name) {
        ExecutorService executor = this.executorFactory.getExecutorService(name, this.httpClientParameters.getThreadPoolSize(), this.httpClientParameters.isThreadPoolMonitoringEnabled());
        HttpClient client = this.sslContextFactoryProvider.provideSslContextFactory().map(HttpClient::new).orElseGet(HttpClient::new);
        client.setMaxConnectionsPerDestination(this.httpClientParameters.getMaxConnectionsPerDestination());
        client.setMaxRequestsQueuedPerDestination(this.httpClientParameters.getMaxRequestsQueuedPerDestination());
        client.setExecutor((Executor)executor);
        client.setCookieStore((CookieStore)new HttpCookieStore.Empty());
        client.setIdleTimeout(this.httpClientParameters.getIdleTimeout().toMillis());
        client.setFollowRedirects(this.httpClientParameters.isFollowRedirectsEnabled());
        return client;
    }

    public HttpClient createClientForHttp2() {
        ExecutorService executor = this.executorFactory.getExecutorService("jetty-http2-client", this.http2ClientParameters.getThreadPoolSize(), this.http2ClientParameters.isThreadPoolMonitoringEnabled());
        HTTP2Client http2Client = new HTTP2Client();
        http2Client.setExecutor((Executor)executor);
        HttpClientTransportOverHTTP2 transport = new HttpClientTransportOverHTTP2(http2Client);
        HttpClient client = this.sslContextFactoryProvider.provideSslContextFactory().map(sslContextFactory -> new HttpClient((HttpClientTransport)transport, sslContextFactory)).orElseThrow(() -> new IllegalStateException("Cannot create http/2 client due to lack of ssl context factory"));
        client.setMaxRequestsQueuedPerDestination(this.http2ClientParameters.getMaxRequestsQueuedPerDestination());
        client.setCookieStore((CookieStore)new HttpCookieStore.Empty());
        client.setIdleTimeout(this.http2ClientParameters.getIdleTimeout().toMillis());
        client.setFollowRedirects(this.httpClientParameters.isFollowRedirectsEnabled());
        return client;
    }
}

