package pl.allegro.tech.hermes.consumers.config;

import io.micrometer.prometheusmetrics.PrometheusConfig;
import java.time.Duration;

public class PrometheusConfigAdapter implements PrometheusConfig {

  private final PrometheusProperties prometheusReporterProperties;

  public PrometheusConfigAdapter(PrometheusProperties prometheusReporterProperties) {
    this.prometheusReporterProperties = prometheusReporterProperties;
  }

  @Override
  public boolean descriptions() {
    return prometheusReporterProperties.isDescriptions();
  }

  @Override
  public Duration step() {
    return prometheusReporterProperties.getStep();
  }

  /** Returning null is fine since we override all the methods from PrometheusConfig. */
  @Override
  public String get(String key) {
    return null; // Nothing to see here, move along.
  }
}
