/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.batch;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.time.Clock;
import java.util.UUID;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.common.exception.InternalProcessingException;
import pl.allegro.tech.hermes.common.metric.MetricsFacade;
import pl.allegro.tech.hermes.consumers.consumer.batch.DirectBufferPool;
import pl.allegro.tech.hermes.consumers.consumer.batch.JsonMessageBatch;
import pl.allegro.tech.hermes.consumers.consumer.batch.MessageBatch;
import pl.allegro.tech.hermes.consumers.consumer.batch.MessageBatchFactory;

public class ByteBufferMessageBatchFactory
implements MessageBatchFactory {
    private final DirectBufferPool bufferPool;
    private final Clock clock;

    public ByteBufferMessageBatchFactory(int poolableSize, int maxPoolSize, Clock clock, MetricsFacade metrics) {
        this.clock = clock;
        this.bufferPool = new DirectBufferPool(maxPoolSize, poolableSize, true);
        metrics.consumer().registerBatchBufferTotalBytesGauge((Object)this.bufferPool, DirectBufferPool::totalMemory);
        metrics.consumer().registerBatchBufferAvailableBytesGauge((Object)this.bufferPool, DirectBufferPool::availableMemory);
    }

    @Override
    public MessageBatch createBatch(Subscription subscription) {
        try {
            ByteBuffer buffer = this.bufferPool.allocate(subscription.getBatchSubscriptionPolicy().getBatchVolume());
            switch (subscription.getContentType()) {
                case JSON: {
                    return new JsonMessageBatch(UUID.randomUUID().toString(), buffer, subscription, this.clock);
                }
            }
            throw new UnsupportedOperationException("Batching is not supported yet for contentType " + String.valueOf(subscription.getContentType()));
        }
        catch (InterruptedException e) {
            throw new InternalProcessingException((Throwable)e);
        }
    }

    @Override
    public void destroyBatch(MessageBatch batch) {
        Preconditions.checkNotNull((Object)batch);
        this.bufferPool.deallocate(batch.getContent());
    }
}

