/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.converter;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.avro.Conversion;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import pl.allegro.tech.hermes.api.ContentType;
import pl.allegro.tech.hermes.api.Topic;
import pl.allegro.tech.hermes.common.message.converter.AvroRecordToBytesConverter;
import pl.allegro.tech.hermes.consumers.consumer.Message;
import pl.allegro.tech.hermes.consumers.consumer.converter.MessageConverter;
import tech.allegro.schema.json2avro.converter.AvroJsonConverter;
import tech.allegro.schema.json2avro.converter.conversions.DecimalAsStringConversion;

public class AvroToJsonMessageConverter
implements MessageConverter {
    private final AvroJsonConverter converter;
    private final List<Conversion<?>> defaultConversions = List.of(DecimalAsStringConversion.INSTANCE);

    public AvroToJsonMessageConverter() {
        this.converter = new AvroJsonConverter(this.defaultConversions.toArray(new Conversion[0]));
    }

    @Override
    public Message convert(Message message, Topic topic) {
        return Message.message().fromMessage(message).withContentType(ContentType.JSON).withData(this.converter.convertToJson(this.recordWithoutMetadata(message.getData(), (Schema)message.getSchema().get().getSchema()))).withNoSchema().build();
    }

    private GenericRecord recordWithoutMetadata(byte[] data, Schema schema) {
        GenericRecord original = AvroRecordToBytesConverter.bytesToRecord((byte[])data, (Schema)schema, this.defaultConversions);
        Schema schemaWithoutMetadata = this.removeMetadataField(schema);
        GenericRecordBuilder builder = new GenericRecordBuilder(schemaWithoutMetadata);
        schemaWithoutMetadata.getFields().forEach(field -> builder.set(field, original.get(field.name())));
        return builder.build();
    }

    private Schema removeMetadataField(Schema schema) {
        return Schema.createRecord(schema.getFields().stream().filter(field -> !"__metadata".equals(field.name())).map(field -> new Schema.Field(field.name(), field.schema(), field.doc(), field.defaultVal())).collect(Collectors.toList()));
    }
}

