/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.offset;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.consumers.consumer.offset.SubscriptionPartition;

public class ConsumerPartitionAssignmentState {
    private static final Logger logger = LoggerFactory.getLogger(ConsumerPartitionAssignmentState.class);
    private final Map<SubscriptionName, Set<Integer>> assigned = new ConcurrentHashMap<SubscriptionName, Set<Integer>>();
    private final Map<SubscriptionName, Long> terms = new ConcurrentHashMap<SubscriptionName, Long>();

    public void assign(SubscriptionName name, Collection<Integer> partitions) {
        this.incrementTerm(name);
        logger.info("Assigning partitions {} of {}, term={}", new Object[]{partitions, name, this.currentTerm(name)});
        this.assigned.compute(name, (subscriptionName, assigned) -> {
            HashSet extended = new HashSet(partitions);
            if (assigned == null) {
                return extended;
            }
            extended.addAll(assigned);
            return extended;
        });
    }

    public void incrementTerm(SubscriptionName name) {
        this.terms.compute(name, (subscriptionName, term) -> term == null ? 0L : term + 1L);
    }

    public void revoke(SubscriptionName name, Collection<Integer> partitions) {
        logger.info("Revoking partitions {} of {}", partitions, (Object)name);
        this.assigned.computeIfPresent(name, (subscriptionName, assigned) -> {
            Set filtered = assigned.stream().filter(p -> !partitions.contains(p)).collect(Collectors.toSet());
            return filtered.isEmpty() ? null : filtered;
        });
    }

    public void revokeAll(SubscriptionName name) {
        logger.info("Revoking all partitions of {}", (Object)name);
        this.assigned.remove(name);
    }

    public long currentTerm(SubscriptionName name) {
        return this.terms.getOrDefault(name, -1L);
    }

    public boolean isAssignedPartitionAtCurrentTerm(SubscriptionPartition subscriptionPartition) {
        return this.currentTerm(subscriptionPartition.getSubscriptionName()) == subscriptionPartition.getPartitionAssignmentTerm() && this.isAssigned(subscriptionPartition.getSubscriptionName(), subscriptionPartition.getPartition());
    }

    public Set<Integer> getAssignedPartitions(SubscriptionName subscriptionName) {
        return this.assigned.get(subscriptionName);
    }

    private boolean isAssigned(SubscriptionName name, int partition) {
        return this.assigned.containsKey(name) && this.assigned.get(name).contains(partition);
    }
}

