/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.result;

import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.api.subscription.metrics.SubscriptionMetricsConfig;
import pl.allegro.tech.hermes.common.metric.MetricsFacade;
import pl.allegro.tech.hermes.consumers.consumer.Message;
import pl.allegro.tech.hermes.consumers.consumer.message.MessageConverter;
import pl.allegro.tech.hermes.consumers.consumer.result.SubscriptionChangeAwareSuccessHandler;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageSendingResult;
import pl.allegro.tech.hermes.metrics.HermesCounter;
import pl.allegro.tech.hermes.metrics.HermesHistogram;
import pl.allegro.tech.hermes.metrics.HermesTimer;
import pl.allegro.tech.hermes.tracker.consumers.Trackers;

public class DefaultSuccessHandler
implements SubscriptionChangeAwareSuccessHandler {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSuccessHandler.class);
    private final Trackers trackers;
    private final SubscriptionName subscriptionName;
    private final MetricsFacade metrics;
    private final Map<Integer, HermesCounter> httpStatusCodes = new ConcurrentHashMap<Integer, HermesCounter>();
    private final HermesCounter throughputInBytes;
    private final HermesCounter successes;
    private final HermesHistogram inflightTime;
    private volatile HermesTimer messageProcessingTime;

    public DefaultSuccessHandler(MetricsFacade metrics, Trackers trackers, SubscriptionName subscriptionName, SubscriptionMetricsConfig metricsConfig) {
        this.metrics = metrics;
        this.trackers = trackers;
        this.subscriptionName = subscriptionName;
        this.throughputInBytes = metrics.subscriptions().throughputInBytes(subscriptionName);
        this.successes = metrics.subscriptions().successes(subscriptionName);
        this.inflightTime = metrics.subscriptions().inflightTimeInMillisHistogram(subscriptionName);
        this.messageProcessingTime = this.metrics.subscriptions().messageProcessingTimeInMillisHistogram(this.subscriptionName, metricsConfig.messageProcessing());
    }

    @Override
    public void handleSuccess(Message message, Subscription subscription, MessageSendingResult result) {
        this.markSuccess(message, result);
        this.trackers.get(subscription).logSent(MessageConverter.toMessageMetadata(message, subscription), result.getHostname());
    }

    @Override
    public void updateSubscription(Subscription subscription) {
        logger.info("Subscription {} updated. Metrics configuration: {}", (Object)subscription.getQualifiedName(), (Object)subscription.getMetricsConfig());
        this.messageProcessingTime = this.metrics.subscriptions().messageProcessingTimeInMillisHistogram(this.subscriptionName, subscription.getMetricsConfig().messageProcessing());
    }

    private void markSuccess(Message message, MessageSendingResult result) {
        this.successes.increment();
        this.throughputInBytes.increment(message.getSize());
        this.markHttpStatusCode(result.getStatusCode());
        this.inflightTime.record(System.currentTimeMillis() - message.getReadingTimestamp());
        this.markMessageProcessingTime(message);
    }

    private void markHttpStatusCode(int statusCode) {
        this.httpStatusCodes.computeIfAbsent(statusCode, integer -> this.metrics.subscriptions().httpAnswerCounter(this.subscriptionName, statusCode)).increment();
    }

    private void markMessageProcessingTime(Message message) {
        if (this.messageProcessingTime != null) {
            Duration processingTime = Duration.ofMillis(System.currentTimeMillis() - message.getPublishingTimestamp());
            this.messageProcessingTime.record(processingTime);
        }
    }
}

