/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender.http;

import java.util.Optional;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import pl.allegro.tech.hermes.common.ssl.DefaultSslContextFactory;
import pl.allegro.tech.hermes.common.ssl.KeyManagersProvider;
import pl.allegro.tech.hermes.common.ssl.KeystoreConfigurationException;
import pl.allegro.tech.hermes.common.ssl.KeystoreProperties;
import pl.allegro.tech.hermes.common.ssl.KeystoreSource;
import pl.allegro.tech.hermes.common.ssl.SslContextFactory;
import pl.allegro.tech.hermes.common.ssl.TrustManagersProvider;
import pl.allegro.tech.hermes.common.ssl.TruststoreConfigurationException;
import pl.allegro.tech.hermes.common.ssl.jvm.JvmKeyManagersProvider;
import pl.allegro.tech.hermes.common.ssl.jvm.JvmTrustManagerProvider;
import pl.allegro.tech.hermes.common.ssl.provided.ProvidedKeyManagersProvider;
import pl.allegro.tech.hermes.common.ssl.provided.ProvidedTrustManagersProvider;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.SslContextParameters;

public class SslContextFactoryProvider {
    private final SslContextFactory sslContextFactory;
    private final SslContextParameters sslContextParams;

    public SslContextFactoryProvider(SslContextFactory sslContextFactory, SslContextParameters sslContextParams) {
        this.sslContextFactory = sslContextFactory;
        this.sslContextParams = sslContextParams;
    }

    public Optional<SslContextFactory.Client> provideSslContextFactory() {
        if (this.sslContextParams.isEnabled()) {
            SslContextFactory.Client sslCtx = new SslContextFactory.Client();
            sslCtx.setEndpointIdentificationAlgorithm("HTTPS");
            sslCtx.setSslContext(this.sslContextFactory().create().getSslContext());
            return Optional.of(sslCtx);
        }
        return Optional.empty();
    }

    private SslContextFactory sslContextFactory() {
        return Optional.ofNullable(this.sslContextFactory).orElseGet(this::defaultSslContextFactory);
    }

    private SslContextFactory defaultSslContextFactory() {
        String protocol = this.sslContextParams.getProtocol();
        KeyManagersProvider keyManagersProvider = this.createKeyManagersProvider();
        TrustManagersProvider trustManagersProvider = this.createTrustManagersProvider();
        return new DefaultSslContextFactory(protocol, keyManagersProvider, trustManagersProvider);
    }

    private KeyManagersProvider createKeyManagersProvider() {
        String keystoreSource = this.sslContextParams.getKeystoreSource();
        if (KeystoreSource.PROVIDED.getValue().equals(keystoreSource)) {
            KeystoreProperties properties = new KeystoreProperties(this.sslContextParams.getKeystoreLocation(), this.sslContextParams.getKeystoreFormat(), this.sslContextParams.getKeystorePassword());
            return new ProvidedKeyManagersProvider(properties);
        }
        if (KeystoreSource.JRE.getValue().equals(keystoreSource)) {
            return new JvmKeyManagersProvider();
        }
        throw new KeystoreConfigurationException(keystoreSource);
    }

    public TrustManagersProvider createTrustManagersProvider() {
        String truststoreSource = this.sslContextParams.getTruststoreSource();
        if (KeystoreSource.PROVIDED.getValue().equals(truststoreSource)) {
            KeystoreProperties properties = new KeystoreProperties(this.sslContextParams.getTruststoreLocation(), this.sslContextParams.getTruststoreFormat(), this.sslContextParams.getTruststorePassword());
            return new ProvidedTrustManagersProvider(properties);
        }
        if (KeystoreSource.JRE.getValue().equals(truststoreSource)) {
            return new JvmTrustManagerProvider();
        }
        throw new TruststoreConfigurationException(truststoreSource);
    }
}

