/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.workload;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.consumers.supervisor.workload.SubscriptionAssignmentView;

public class WorkDistributionChanges {
    private final SubscriptionAssignmentView deletions;
    private final SubscriptionAssignmentView additions;
    private final Set<String> modifiedConsumerNodes;

    WorkDistributionChanges(SubscriptionAssignmentView deletions, SubscriptionAssignmentView additions) {
        this.deletions = deletions;
        this.additions = additions;
        this.modifiedConsumerNodes = Sets.union(deletions.getConsumerNodes(), additions.getConsumerNodes());
    }

    int getDeletedAssignmentsCount() {
        return this.deletions.getAllAssignments().size();
    }

    int getCreatedAssignmentsCount() {
        return this.additions.getAllAssignments().size();
    }

    Set<String> getModifiedConsumerNodes() {
        return this.modifiedConsumerNodes;
    }

    public Set<SubscriptionName> getRebalancedSubscriptions() {
        return Stream.concat(this.additions.getSubscriptions().stream(), this.deletions.getSubscriptions().stream()).collect(Collectors.toSet());
    }
}

