/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.workload.weighted;

import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.TimeUnit;

class ExponentiallyWeightedMovingAverage {
    private final Duration windowSize;
    private Instant previousUpdateTimestamp;
    private double currentAverage = 0.0;

    ExponentiallyWeightedMovingAverage(Duration windowSize) {
        this.windowSize = windowSize;
    }

    double update(double sample, Instant now) {
        if (this.previousUpdateTimestamp == null) {
            this.currentAverage = sample;
        } else {
            Duration elapsed = Duration.between(this.previousUpdateTimestamp, now);
            long elapsedMillis = Math.max(TimeUnit.MILLISECONDS.convert(elapsed), 0L);
            double alpha = 1.0 - Math.exp(-1.0 * ((double)elapsedMillis / (double)this.windowSize.toMillis()));
            this.currentAverage = sample * alpha + this.currentAverage * (1.0 - alpha);
        }
        this.previousUpdateTimestamp = now;
        return this.currentAverage;
    }
}

