/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.oauth;

import com.google.common.util.concurrent.RateLimiter;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.api.OAuthProvider;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.consumers.consumer.ConsumerAuthorizationHandler;
import pl.allegro.tech.hermes.consumers.consumer.Message;
import pl.allegro.tech.hermes.consumers.consumer.oauth.OAuthProviderCacheListener;
import pl.allegro.tech.hermes.consumers.consumer.oauth.OAuthProvidersNotifyingCache;
import pl.allegro.tech.hermes.consumers.consumer.oauth.OAuthSubscriptionHandler;
import pl.allegro.tech.hermes.consumers.consumer.oauth.OAuthSubscriptionHandlerFactory;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageSendingResult;

public class OAuthConsumerAuthorizationHandler
implements ConsumerAuthorizationHandler,
OAuthProviderCacheListener {
    private static final Logger logger = LoggerFactory.getLogger(OAuthConsumerAuthorizationHandler.class);
    private final OAuthSubscriptionHandlerFactory handlerFactory;
    private final Map<SubscriptionName, OAuthSubscriptionHandler> handlers = new ConcurrentHashMap<SubscriptionName, OAuthSubscriptionHandler>();
    private final RateLimiter missingHandlersCreationRateLimiter;

    public OAuthConsumerAuthorizationHandler(OAuthSubscriptionHandlerFactory handlerFactory, Duration missingSubscriptionHandlersCreationDelay, OAuthProvidersNotifyingCache oAuthProvidersCache) {
        this.handlerFactory = handlerFactory;
        this.missingHandlersCreationRateLimiter = RateLimiter.create((double)missingSubscriptionHandlersCreationDelay.toSeconds());
        oAuthProvidersCache.setListener(this);
    }

    @Override
    public void createSubscriptionHandler(SubscriptionName subscriptionName) {
        this.handlerFactory.create(subscriptionName).ifPresent(handler -> {
            logger.info("OAuth handler for subscription {} created", (Object)subscriptionName);
            this.handlers.put(subscriptionName, (OAuthSubscriptionHandler)handler);
            handler.initialize();
        });
    }

    @Override
    public void removeSubscriptionHandler(SubscriptionName subscriptionName) {
        if (this.handlers.remove(subscriptionName) != null) {
            logger.info("OAuth handler for subscription {} removed", (Object)subscriptionName);
        }
    }

    @Override
    public void updateSubscription(SubscriptionName subscriptionName) {
        this.removeSubscriptionHandler(subscriptionName);
        this.createSubscriptionHandler(subscriptionName);
    }

    @Override
    public void oAuthProviderUpdate(OAuthProvider oAuthProvider) {
        logger.info("Updated OAuth provider {}", (Object)oAuthProvider.getName());
        List<SubscriptionName> subscriptions = this.handlers.entrySet().stream().filter(entry -> ((OAuthSubscriptionHandler)entry.getValue()).getProviderName().equals(oAuthProvider.getName())).map(Map.Entry::getKey).collect(Collectors.toList());
        subscriptions.forEach(this::updateSubscription);
    }

    @Override
    public void handleSuccess(Message message, Subscription subscription, MessageSendingResult result) {
        if (this.shouldHandle(subscription)) {
            this.getSubscriptionHandler(subscription.getQualifiedName()).ifPresent(OAuthSubscriptionHandler::handleSuccess);
        }
    }

    @Override
    public void handleFailed(Message message, Subscription subscription, MessageSendingResult result) {
        if (this.shouldHandle(subscription)) {
            this.getSubscriptionHandler(subscription.getQualifiedName()).ifPresent(h -> h.handleFailed(subscription, result));
        }
    }

    @Override
    public void handleDiscarded(Message message, Subscription subscription, MessageSendingResult result) {
    }

    private boolean shouldHandle(Subscription subscription) {
        return subscription.hasOAuthPolicy();
    }

    private Optional<OAuthSubscriptionHandler> getSubscriptionHandler(SubscriptionName subscriptionName) {
        if (this.handlers.containsKey(subscriptionName)) {
            return Optional.of(this.handlers.get(subscriptionName));
        }
        return this.tryCreatingMissingHandler(subscriptionName);
    }

    private Optional<OAuthSubscriptionHandler> tryCreatingMissingHandler(SubscriptionName subscriptionName) {
        if (this.missingHandlersCreationRateLimiter.tryAcquire()) {
            this.createSubscriptionHandler(subscriptionName);
            return Optional.ofNullable(this.handlers.get(subscriptionName));
        }
        return Optional.empty();
    }
}

