/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.oauth;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.consumers.consumer.oauth.OAuthAccessToken;
import pl.allegro.tech.hermes.consumers.consumer.oauth.OAuthAccessTokens;
import pl.allegro.tech.hermes.consumers.consumer.oauth.OAuthAccessTokensLoader;

public class OAuthSubscriptionAccessTokens
implements OAuthAccessTokens {
    private static final Logger logger = LoggerFactory.getLogger(OAuthSubscriptionAccessTokens.class);
    private final LoadingCache<SubscriptionName, OAuthAccessToken> subscriptionTokens;
    private final OAuthAccessTokensLoader tokenLoader;

    public OAuthSubscriptionAccessTokens(OAuthAccessTokensLoader tokenLoader, long subscriptionTokensCacheMaxSize) {
        this.tokenLoader = tokenLoader;
        this.subscriptionTokens = CacheBuilder.newBuilder().maximumSize(subscriptionTokensCacheMaxSize).build((CacheLoader)tokenLoader);
    }

    @Override
    public Optional<OAuthAccessToken> getTokenIfPresent(SubscriptionName subscriptionName) {
        return Optional.ofNullable((OAuthAccessToken)this.subscriptionTokens.getIfPresent((Object)subscriptionName));
    }

    @Override
    public Optional<OAuthAccessToken> loadToken(SubscriptionName subscriptionName) {
        try {
            return Optional.ofNullable((OAuthAccessToken)this.subscriptionTokens.get((Object)subscriptionName));
        }
        catch (Exception e) {
            logger.error("Could not get access token for subscription {}", (Object)subscriptionName, (Object)e);
            return Optional.empty();
        }
    }

    @Override
    public void refreshToken(SubscriptionName subscriptionName) {
        try {
            OAuthAccessToken token = this.tokenLoader.load(subscriptionName);
            this.subscriptionTokens.put((Object)subscriptionName, (Object)token);
        }
        catch (Exception e) {
            logger.error("An error occurred while refreshing access token for subscription {}", (Object)subscriptionName, (Object)e);
        }
    }

    @Override
    public boolean tokenExists(SubscriptionName subscriptionName) {
        return this.subscriptionTokens.getIfPresent((Object)subscriptionName) != null;
    }
}

