/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.offset;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.common.TopicPartition;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.consumers.consumer.offset.ConsumerPartitionAssignmentState;

public class OffsetCommitterConsumerRebalanceListener
implements ConsumerRebalanceListener {
    private final SubscriptionName name;
    private final ConsumerPartitionAssignmentState state;

    public OffsetCommitterConsumerRebalanceListener(SubscriptionName name, ConsumerPartitionAssignmentState state) {
        this.name = name;
        this.state = state;
    }

    public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
        this.state.revoke(this.name, this.integerPartitions(partitions));
    }

    public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
        this.state.assign(this.name, this.integerPartitions(partitions));
    }

    private Set<Integer> integerPartitions(Collection<TopicPartition> partitions) {
        return partitions.stream().map(TopicPartition::partition).collect(Collectors.toSet());
    }
}

