/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.profiling;

import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StopWatch;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.consumers.consumer.profiling.ConsumerProfiler;
import pl.allegro.tech.hermes.consumers.consumer.profiling.ConsumerRun;

public class DefaultConsumerProfiler
implements ConsumerProfiler {
    private static final Logger logger = LoggerFactory.getLogger(DefaultConsumerProfiler.class);
    private final SubscriptionName subscriptionName;
    private final long profilingThresholdMs;
    private StopWatch stopWatch;
    private StopWatch partialMeasurements;
    private long retryDelayMillis = 0L;

    public DefaultConsumerProfiler(SubscriptionName subscriptionName, long profilingThresholdMs) {
        this.subscriptionName = subscriptionName;
        this.profilingThresholdMs = profilingThresholdMs;
    }

    @Override
    public synchronized void startMeasurements(String measurement) {
        this.stopWatch = new StopWatch();
        this.stopWatch.start(measurement);
    }

    @Override
    public synchronized void measure(String measurement) {
        this.stopWatch.stop();
        this.stopWatch.start(measurement);
    }

    @Override
    public synchronized void startPartialMeasurement(String measurement) {
        if (this.partialMeasurements == null) {
            this.partialMeasurements = new StopWatch();
        }
        this.partialMeasurements.start(measurement);
    }

    @Override
    public synchronized void stopPartialMeasurement() {
        this.partialMeasurements.stop();
    }

    @Override
    public synchronized void saveRetryDelay(long retryDelay) {
        this.retryDelayMillis = retryDelay;
    }

    @Override
    public synchronized void flushMeasurements(ConsumerRun consumerRun) {
        this.stopWatch.stop();
        if (this.stopWatch.getTotalTimeMillis() > this.profilingThresholdMs) {
            this.logMeasurements(consumerRun);
        }
    }

    private void logMeasurements(ConsumerRun consumerRun) {
        if (this.partialMeasurements != null) {
            logger.info("Consumer profiler measurements for subscription {} and {} run: \n {} partialMeasurements: {} retryDelayMillis {}", new Object[]{this.subscriptionName, consumerRun, this.stopWatch.prettyPrint(TimeUnit.MILLISECONDS), this.partialMeasurements.prettyPrint(TimeUnit.MILLISECONDS), this.retryDelayMillis});
        } else {
            logger.info("Consumer profiler measurements for subscription {} and {} run: \n {} partialMeasurements: {}, retryDelayMillis {}", new Object[]{this.subscriptionName, consumerRun, this.stopWatch.prettyPrint(TimeUnit.MILLISECONDS), null, this.retryDelayMillis});
        }
    }
}

