/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender.timeout;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;

public class FutureAsyncTimeout {
    private final ScheduledExecutorService executor;

    public FutureAsyncTimeout(ScheduledExecutorService scheduledExecutorService) {
        this.executor = scheduledExecutorService;
    }

    public <T> CompletableFuture<T> within(CompletableFuture<T> future, Duration duration, Function<Throwable, T> exceptionMapper) {
        return future.applyToEither((CompletionStage)this.failAfter(duration, exceptionMapper), Function.identity());
    }

    private <T> CompletableFuture<T> failAfter(Duration duration, Function<Throwable, T> exceptionMapper) {
        CompletableFuture promise = new CompletableFuture();
        this.executor.schedule(() -> {
            TimeoutException ex = new TimeoutException("Timeout after " + String.valueOf(duration));
            return promise.complete(exceptionMapper.apply(ex));
        }, duration.toMillis(), TimeUnit.MILLISECONDS);
        return promise;
    }

    public void shutdown() {
        this.executor.shutdown();
    }
}

