/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.workload.weighted;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.consumers.subscription.id.SubscriptionId;
import pl.allegro.tech.hermes.consumers.subscription.id.SubscriptionIds;
import pl.allegro.tech.hermes.consumers.supervisor.workload.sbe.stubs.ConsumerLoadDecoder;
import pl.allegro.tech.hermes.consumers.supervisor.workload.sbe.stubs.MessageHeaderDecoder;
import pl.allegro.tech.hermes.consumers.supervisor.workload.weighted.ConsumerNodeLoad;
import pl.allegro.tech.hermes.consumers.supervisor.workload.weighted.SubscriptionLoad;

class ConsumerNodeLoadDecoder {
    private static final Logger logger = LoggerFactory.getLogger(ConsumerNodeLoadDecoder.class);
    private final SubscriptionIds subscriptionIds;

    ConsumerNodeLoadDecoder(SubscriptionIds subscriptionIds) {
        this.subscriptionIds = subscriptionIds;
    }

    ConsumerNodeLoad decode(byte[] bytes) {
        MessageHeaderDecoder header = new MessageHeaderDecoder();
        ConsumerLoadDecoder body = new ConsumerLoadDecoder();
        UnsafeBuffer buffer = new UnsafeBuffer(bytes);
        header.wrap((DirectBuffer)buffer, 0);
        if (header.schemaId() != 2 || header.templateId() != 2) {
            logger.warn("Unable to decode consumer node load, schema or template id mismatch. Required by decoder: [schema id={}, template id={}], encoded in payload: [schema id={}, template id={}]", new Object[]{2, 2, header.schemaId(), header.templateId()});
            return ConsumerNodeLoad.UNDEFINED;
        }
        body.wrap((DirectBuffer)buffer, header.encodedLength(), header.blockLength(), header.version());
        return new ConsumerNodeLoad(body.cpuUtilization(), this.decodeSubscriptionLoads(body));
    }

    private Map<SubscriptionName, SubscriptionLoad> decodeSubscriptionLoads(ConsumerLoadDecoder body) {
        HashMap<SubscriptionName, SubscriptionLoad> subscriptionLoads = new HashMap<SubscriptionName, SubscriptionLoad>();
        for (ConsumerLoadDecoder.SubscriptionsDecoder loadPerSubscriptionDecoder : body.subscriptions()) {
            long id = loadPerSubscriptionDecoder.id();
            Optional<SubscriptionId> subscriptionId = this.subscriptionIds.getSubscriptionId(id);
            if (!subscriptionId.isPresent()) continue;
            double operationsPerSecond = loadPerSubscriptionDecoder.operationsPerSecond();
            SubscriptionLoad load = new SubscriptionLoad(operationsPerSecond);
            subscriptionLoads.put(subscriptionId.get().getSubscriptionName(), load);
        }
        return subscriptionLoads;
    }
}

