/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.rate.calculator;

import java.util.EnumMap;
import java.util.Map;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.consumers.consumer.rate.SendCounters;
import pl.allegro.tech.hermes.consumers.consumer.rate.calculator.HeartbeatModeOutputRateCalculator;
import pl.allegro.tech.hermes.consumers.consumer.rate.calculator.ModeOutputRateCalculator;
import pl.allegro.tech.hermes.consumers.consumer.rate.calculator.NormalModeOutputRateCalculator;
import pl.allegro.tech.hermes.consumers.consumer.rate.calculator.OutputRateCalculationResult;
import pl.allegro.tech.hermes.consumers.consumer.rate.calculator.RateCalculatorParameters;
import pl.allegro.tech.hermes.consumers.consumer.rate.calculator.SlowModeOutputRateCalculator;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.MaxRateProvider;

public class OutputRateCalculator {
    private final Map<Mode, ModeOutputRateCalculator> modeCalculators = new EnumMap<Mode, ModeOutputRateCalculator>(Mode.class);
    private final MaxRateProvider maxRateProvider;

    public OutputRateCalculator(RateCalculatorParameters rateCalculatorParameters, MaxRateProvider maxRateProvider) {
        this.maxRateProvider = maxRateProvider;
        this.modeCalculators.put(Mode.NORMAL, new NormalModeOutputRateCalculator(rateCalculatorParameters.getConvergenceFactor(), 1.0 / (double)rateCalculatorParameters.getLimiterSlowModeDelay().toSeconds(), rateCalculatorParameters.getFailuresSpeedUpToleranceRatio(), rateCalculatorParameters.getFailuresNoChangeToleranceRatio()));
        this.modeCalculators.put(Mode.SLOW, new SlowModeOutputRateCalculator(1.0 / (double)rateCalculatorParameters.getLimiterHeartbeatModeDelay().toSeconds()));
        this.modeCalculators.put(Mode.HEARTBEAT, new HeartbeatModeOutputRateCalculator(1.0 / (double)rateCalculatorParameters.getLimiterSlowModeDelay().toSeconds()));
    }

    public OutputRateCalculationResult recalculateRate(SendCounters counters, Mode currentMode, double currentRateLimit) {
        double maximumRate = this.maxRateProvider.get();
        OutputRateCalculationResult recalculatedResult = this.modeCalculators.get((Object)currentMode).calculateOutputRate(currentRateLimit, maximumRate, counters);
        if (recalculatedResult.rate() > maximumRate) {
            recalculatedResult = OutputRateCalculationResult.adjustRate(recalculatedResult, maximumRate);
        }
        return recalculatedResult;
    }

    public void updateSubscription(Subscription newSubscription) {
        this.maxRateProvider.updateSubscription(newSubscription);
    }

    public void start() {
        this.maxRateProvider.start();
    }

    public void shutdown() {
        this.maxRateProvider.shutdown();
    }

    public static enum Mode {
        NORMAL,
        SLOW,
        HEARTBEAT;

    }
}

