/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender.googlepubsub;

import com.google.protobuf.ByteString;
import com.google.pubsub.v1.PubsubMessage;
import java.io.IOException;
import pl.allegro.tech.hermes.consumers.consumer.Message;
import pl.allegro.tech.hermes.consumers.consumer.sender.googlepubsub.GooglePubSubMessageCompressionException;
import pl.allegro.tech.hermes.consumers.consumer.sender.googlepubsub.GooglePubSubMessageTransformer;
import pl.allegro.tech.hermes.consumers.consumer.sender.googlepubsub.GooglePubSubMessageTransformerRaw;
import pl.allegro.tech.hermes.consumers.consumer.sender.googlepubsub.MessageCompressor;
import pl.allegro.tech.hermes.consumers.consumer.trace.MetadataAppender;

class GooglePubSubMessageTransformerCompression
implements GooglePubSubMessageTransformer {
    private final MessageCompressor compressor;
    private final Long compressionThresholdBytes;
    private final GooglePubSubMessageTransformerRaw rawTransformer;
    private final MetadataAppender<PubsubMessage> metadataAppender;

    GooglePubSubMessageTransformerCompression(Long compressionThresholdBytes, GooglePubSubMessageTransformerRaw rawTransformer, MetadataAppender<PubsubMessage> metadataAppender, MessageCompressor compressor) {
        this.compressor = compressor;
        this.compressionThresholdBytes = compressionThresholdBytes;
        this.rawTransformer = rawTransformer;
        this.metadataAppender = metadataAppender;
    }

    @Override
    public PubsubMessage fromHermesMessage(Message message) {
        byte[] data = message.getData();
        if ((long)data.length > this.compressionThresholdBytes) {
            return this.compressHermesMessage(message);
        }
        return this.rawTransformer.fromHermesMessage(message);
    }

    private PubsubMessage compressHermesMessage(Message message) {
        try {
            PubsubMessage pubsubMessage = PubsubMessage.newBuilder().setData(ByteString.copyFrom((byte[])this.compressor.compress(message.getData()))).build();
            return this.metadataAppender.append(pubsubMessage, message);
        }
        catch (IOException e) {
            throw new GooglePubSubMessageCompressionException("Error on PubSub message compression", e);
        }
    }
}

