/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender.http.auth;

import java.util.Optional;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.consumers.consumer.oauth.OAuthAccessTokens;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.auth.BasicAuthProvider;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.auth.HttpAuthorizationProvider;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.auth.OAuthHttpAuthorizationProvider;

public class HttpAuthorizationProviderFactory {
    private final OAuthAccessTokens accessTokens;

    public HttpAuthorizationProviderFactory(OAuthAccessTokens accessTokens) {
        this.accessTokens = accessTokens;
    }

    public Optional<HttpAuthorizationProvider> create(Subscription subscription) {
        if (subscription.getEndpoint().containsCredentials()) {
            return Optional.of(new BasicAuthProvider(subscription.getEndpoint()));
        }
        if (subscription.hasOAuthPolicy()) {
            return Optional.of(new OAuthHttpAuthorizationProvider(subscription.getQualifiedName(), this.accessTokens));
        }
        return Optional.empty();
    }
}

