/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.process;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.common.exception.RetransmissionException;
import pl.allegro.tech.hermes.common.kafka.offset.PartitionOffset;
import pl.allegro.tech.hermes.common.kafka.offset.PartitionOffsets;
import pl.allegro.tech.hermes.common.kafka.offset.SubscriptionOffsetChangeIndicator;
import pl.allegro.tech.hermes.consumers.consumer.Consumer;

public class Retransmitter {
    private static final Logger logger = LoggerFactory.getLogger(Retransmitter.class);
    private final SubscriptionOffsetChangeIndicator subscriptionOffsetChangeIndicator;
    private final String brokersClusterName;

    public Retransmitter(SubscriptionOffsetChangeIndicator subscriptionOffsetChangeIndicator, String kafkaClusterName) {
        this.subscriptionOffsetChangeIndicator = subscriptionOffsetChangeIndicator;
        this.brokersClusterName = kafkaClusterName;
    }

    public void reloadOffsets(SubscriptionName subscriptionName, Consumer consumer) {
        logger.info("Reloading offsets for {}", (Object)subscriptionName);
        try {
            PartitionOffsets offsets = this.subscriptionOffsetChangeIndicator.getSubscriptionOffsets(subscriptionName.getTopicName(), subscriptionName.getName(), this.brokersClusterName, consumer.getAssignedPartitions());
            PartitionOffsets movedOffsets = consumer.moveOffset(offsets);
            for (PartitionOffset partitionOffset : movedOffsets) {
                this.subscriptionOffsetChangeIndicator.removeOffset(subscriptionName.getTopicName(), subscriptionName.getName(), this.brokersClusterName, partitionOffset.getTopic(), partitionOffset.getPartition());
                logger.info("Removed offset indicator for subscription={} and partition={}", (Object)subscriptionName, (Object)partitionOffset.getPartition());
            }
        }
        catch (Exception ex) {
            throw new RetransmissionException((Throwable)ex);
        }
    }
}

