/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.workload;

import java.util.List;
import java.util.Optional;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import pl.allegro.tech.hermes.common.exception.InternalProcessingException;

class ZookeeperOperations {
    private final CuratorFramework curator;

    ZookeeperOperations(CuratorFramework curator) {
        this.curator = curator;
    }

    void writeOrCreatePersistent(String path, byte[] serializedData) throws Exception {
        try {
            this.curator.setData().forPath(path, serializedData);
        }
        catch (KeeperException.NoNodeException e) {
            try {
                ((ACLBackgroundPathAndBytesable)this.curator.create().creatingParentContainersIfNeeded().withMode(CreateMode.PERSISTENT)).forPath(path, serializedData);
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {
                // empty catch block
            }
        }
    }

    Optional<byte[]> getNodeData(String path) {
        try {
            if (this.curator.checkExists().forPath(path) != null) {
                return Optional.of((byte[])this.curator.getData().forPath(path));
            }
        }
        catch (Exception e) {
            throw new InternalProcessingException(String.format("Could not read node data on path %s", path), (Throwable)e);
        }
        return Optional.empty();
    }

    void deleteNode(String path) {
        try {
            if (this.curator.checkExists().forPath(path) != null) {
                this.curator.delete().forPath(path);
            }
        }
        catch (Exception e) {
            throw new InternalProcessingException("Could not delete node " + path, (Throwable)e);
        }
    }

    List<String> getNodeChildren(String path) {
        try {
            return (List)this.curator.getChildren().forPath(path);
        }
        catch (Exception e) {
            throw new InternalProcessingException("Could not get children of node " + path, (Throwable)e);
        }
    }

    boolean exists(String path) {
        try {
            return this.curator.checkExists().forPath(path) != null;
        }
        catch (Exception e) {
            throw new InternalProcessingException("Unable to check existence of node " + path, (Throwable)e);
        }
    }
}

