/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.workload.weighted;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import pl.allegro.tech.hermes.consumers.supervisor.workload.weighted.ConsumerNodeLoad;
import pl.allegro.tech.hermes.consumers.supervisor.workload.weighted.ConsumerTask;
import pl.allegro.tech.hermes.consumers.supervisor.workload.weighted.Weight;

class ConsumerNode {
    static Comparator<ConsumerNode> LIGHTEST_CONSUMER_FIRST = Comparator.comparing(ConsumerNode::getWeight);
    private final String consumerId;
    private final ConsumerNodeLoad initialLoad;
    private final int maxSubscriptionsPerConsumer;
    private final Set<ConsumerTask> tasks = new HashSet<ConsumerTask>();
    private Weight weight = Weight.ZERO;

    ConsumerNode(String consumerId, ConsumerNodeLoad initialLoad, int maxSubscriptionsPerConsumer) {
        this.consumerId = consumerId;
        this.initialLoad = initialLoad;
        this.maxSubscriptionsPerConsumer = maxSubscriptionsPerConsumer;
    }

    String getConsumerId() {
        return this.consumerId;
    }

    void assign(ConsumerTask task) {
        this.tasks.add(task);
        this.weight = this.weight.add(task.getWeight());
    }

    void unassign(ConsumerTask task) {
        this.tasks.remove(task);
        this.weight = this.weight.subtract(task.getWeight());
    }

    void swap(ConsumerTask moveOut, ConsumerTask moveIn) {
        this.unassign(moveOut);
        this.assign(moveIn);
    }

    Set<ConsumerTask> getAssignedTasks() {
        return this.tasks;
    }

    int getAssignedTaskCount() {
        return this.tasks.size();
    }

    boolean isNotAssigned(ConsumerTask consumerTask) {
        return !this.tasks.contains(consumerTask);
    }

    boolean isFull() {
        return this.tasks.size() >= this.maxSubscriptionsPerConsumer;
    }

    Weight getWeight() {
        return this.weight;
    }

    ConsumerNodeLoad getInitialLoad() {
        return this.initialLoad;
    }

    public String toString() {
        return this.consumerId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConsumerNode that = (ConsumerNode)o;
        return Objects.equals(this.consumerId, that.consumerId);
    }

    public int hashCode() {
        return Objects.hash(this.consumerId);
    }
}

