/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.workload.weighted;

import java.time.Instant;
import java.util.Comparator;
import java.util.Objects;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.consumers.supervisor.workload.weighted.SubscriptionProfile;
import pl.allegro.tech.hermes.consumers.supervisor.workload.weighted.Weight;

class ConsumerTask {
    static Comparator<ConsumerTask> HEAVIEST_TASK_FIRST = Comparator.comparing(ConsumerTask::getWeight).reversed();
    private final SubscriptionName subscriptionName;
    private final Instant lastRebalanceTimestamp;
    private final Weight weight;

    ConsumerTask(SubscriptionName subscriptionName, SubscriptionProfile subscriptionProfile) {
        this.subscriptionName = subscriptionName;
        this.lastRebalanceTimestamp = subscriptionProfile.getLastRebalanceTimestamp();
        this.weight = subscriptionProfile.getWeight();
    }

    SubscriptionName getSubscriptionName() {
        return this.subscriptionName;
    }

    Weight getWeight() {
        return this.weight;
    }

    Instant getLastRebalanceTimestamp() {
        return this.lastRebalanceTimestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConsumerTask that = (ConsumerTask)o;
        return Objects.equals(this.subscriptionName, that.subscriptionName);
    }

    public int hashCode() {
        return Objects.hash(this.subscriptionName);
    }
}

