/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.rate;

import com.google.common.util.concurrent.AtomicDouble;
import java.time.Clock;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.math.Fraction;

public class SendCounters {
    private final AtomicInteger successes = new AtomicInteger(0);
    private final AtomicInteger failures = new AtomicInteger(0);
    private final AtomicInteger attempted = new AtomicInteger(0);
    private final AtomicDouble rate = new AtomicDouble(0.0);
    private final Clock clock;
    private volatile long lastReset;

    public SendCounters(Clock clock) {
        this.clock = clock;
    }

    public SendCounters incrementFailures() {
        this.failures.incrementAndGet();
        return this;
    }

    public SendCounters incrementSuccesses() {
        this.successes.incrementAndGet();
        return this;
    }

    public SendCounters incrementAttempted() {
        this.attempted.incrementAndGet();
        return this;
    }

    public void reset() {
        this.failures.set(0);
        this.successes.set(0);
        long now = this.clock.millis();
        long elapsedSeconds = TimeUnit.MILLISECONDS.toSeconds(now - this.lastReset);
        this.rate.set(this.attempted.doubleValue() / (double)Math.max(elapsedSeconds, 1L));
        this.attempted.set(0);
        this.lastReset = now;
    }

    public boolean noFailures() {
        return this.failures.intValue() == 0;
    }

    public boolean hasFailures() {
        return this.failures.intValue() > 0;
    }

    public boolean majorityOfFailures() {
        return this.failures.intValue() > this.successes.intValue();
    }

    public boolean onlySuccessess() {
        return this.successes.intValue() > 0 && this.failures.intValue() == 0;
    }

    public boolean failuresRatioExceeds(double threshold) {
        if (this.hasFailures()) {
            Fraction failuresRatio = Fraction.getFraction((int)this.failures.intValue(), (int)(this.failures.intValue() + this.successes.intValue()));
            return failuresRatio.compareTo(Fraction.getFraction((double)threshold)) > 0;
        }
        return false;
    }

    public double getRate() {
        return this.rate.get();
    }
}

