/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender.googlepubsub;

import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.pubsub.v1.Publisher;
import com.google.pubsub.v1.TopicName;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.consumers.consumer.sender.googlepubsub.GooglePubSubClient;
import pl.allegro.tech.hermes.consumers.consumer.sender.googlepubsub.GooglePubSubSenderTarget;

class GooglePubSubClientsPool {
    private static final Logger logger = LoggerFactory.getLogger(GooglePubSubClientsPool.class);
    private final CredentialsProvider credentialsProvider;
    private final ExecutorProvider publishingExecutorProvider;
    private final RetrySettings retrySettings;
    private final BatchingSettings batchingSettings;
    private final Map<GooglePubSubSenderTarget, GooglePubSubClient> clients = new HashMap<GooglePubSubSenderTarget, GooglePubSubClient>();
    private final Map<GooglePubSubSenderTarget, Integer> counters = new HashMap<GooglePubSubSenderTarget, Integer>();
    private final TransportChannelProvider transportChannelProvider;

    GooglePubSubClientsPool(CredentialsProvider credentialsProvider, ExecutorProvider publishingExecutorProvider, RetrySettings retrySettings, BatchingSettings batchingSettings, TransportChannelProvider transportChannelProvider) {
        this.credentialsProvider = credentialsProvider;
        this.publishingExecutorProvider = publishingExecutorProvider;
        this.retrySettings = retrySettings;
        this.batchingSettings = batchingSettings;
        this.transportChannelProvider = transportChannelProvider;
    }

    synchronized GooglePubSubClient acquire(GooglePubSubSenderTarget resolvedTarget) throws IOException {
        GooglePubSubClient client = this.clients.get(resolvedTarget);
        if (client == null) {
            client = this.createClient(resolvedTarget);
        }
        this.clients.put(resolvedTarget, client);
        Integer counter = this.counters.getOrDefault(resolvedTarget, 0);
        counter = counter + 1;
        this.counters.put(resolvedTarget, counter);
        return client;
    }

    synchronized void release(GooglePubSubSenderTarget resolvedTarget) {
        Integer counter = this.counters.getOrDefault(resolvedTarget, 0);
        if (counter == 0) {
            logger.warn("Attempt to release GooglePubSubClient that is not acquired");
        } else if (counter == 1) {
            this.counters.remove(resolvedTarget);
            GooglePubSubClient client = this.clients.remove(resolvedTarget);
            client.shutdown();
        } else if (counter > 1) {
            counter = counter - 1;
            this.counters.put(resolvedTarget, counter);
        }
    }

    synchronized void shutdown() {
        this.clients.values().forEach(GooglePubSubClient::shutdown);
        this.clients.clear();
        this.counters.clear();
    }

    protected GooglePubSubClient createClient(GooglePubSubSenderTarget resolvedTarget) throws IOException {
        Publisher.Builder builder = Publisher.newBuilder((TopicName)resolvedTarget.getTopicName()).setEndpoint(resolvedTarget.getPubSubEndpoint()).setCredentialsProvider(this.credentialsProvider).setRetrySettings(this.retrySettings).setBatchingSettings(this.batchingSettings).setExecutorProvider(this.publishingExecutorProvider);
        Publisher publisher = this.transportChannelProvider == null ? builder.build() : builder.setChannelProvider(this.transportChannelProvider).build();
        return new GooglePubSubClient(publisher);
    }
}

