/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpServer;
import io.micrometer.prometheusmetrics.PrometheusMeterRegistry;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.List;
import pl.allegro.tech.hermes.consumers.health.ConsumerMonitor;

public class ConsumerHttpServer {
    private final HttpServer server;
    private static final String STATUS_UP = "{\"status\": \"UP\"}";

    public ConsumerHttpServer(int healthCheckPort, ConsumerMonitor monitor, ObjectMapper mapper, PrometheusMeterRegistry meterRegistry) throws IOException {
        this.server = this.createServer(healthCheckPort);
        this.server.createContext("/status/health", exchange -> ConsumerHttpServer.respondWithJson(exchange, STATUS_UP));
        this.server.createContext("/status/subscriptions", exchange -> ConsumerHttpServer.respondWithObject(exchange, mapper, monitor.check("subscriptions")));
        this.server.createContext("/status/subscriptionsCount", exchange -> ConsumerHttpServer.respondWithObject(exchange, mapper, monitor.check("subscriptionsCount")));
        this.server.createContext("/status/prometheus", exchange -> {
            exchange.getResponseHeaders().add("Content-Type", "text/plain;version=0.0.4;charset=utf-8");
            ConsumerHttpServer.respondWithString(exchange, meterRegistry.scrape());
        });
    }

    private HttpServer createServer(int port) throws IOException {
        HttpServer httpServer = HttpServer.create(new InetSocketAddress(port), 0);
        httpServer.setExecutor(null);
        return httpServer;
    }

    private static void respondWithObject(HttpExchange httpExchange, ObjectMapper mapper, Object response) throws IOException {
        ConsumerHttpServer.respondWithJson(httpExchange, mapper.writeValueAsString(response));
    }

    private static void respondWithJson(HttpExchange httpExchange, String response) throws IOException {
        httpExchange.getResponseHeaders().put("Content-Type", List.of("application/json"));
        ConsumerHttpServer.respondWithString(httpExchange, response);
    }

    private static void respondWithString(HttpExchange httpExchange, String response) throws IOException {
        httpExchange.sendResponseHeaders(Response.Status.OK.getStatusCode(), response.length());
        OutputStream os = httpExchange.getResponseBody();
        os.write(response.getBytes());
        os.close();
    }

    public void start() {
        this.server.start();
    }

    public void stop() {
        this.server.stop(0);
    }

    public int getPort() {
        return this.server.getAddress().getPort();
    }
}

