/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.workload.weighted;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import pl.allegro.tech.hermes.common.metric.MetricsFacade;
import pl.allegro.tech.hermes.common.metric.WorkloadMetrics;
import pl.allegro.tech.hermes.consumers.supervisor.workload.weighted.ConsumerNode;
import pl.allegro.tech.hermes.consumers.supervisor.workload.weighted.Weight;

public class WeightedWorkloadMetricsReporter {
    private final WorkloadMetrics metrics;
    private final Map<String, Double> currentWeights = new ConcurrentHashMap<String, Double>();
    private final Map<String, Double> proposedWeights = new ConcurrentHashMap<String, Double>();
    private final Map<String, Double> currentScores = new ConcurrentHashMap<String, Double>();
    private final Map<String, Double> proposedScores = new ConcurrentHashMap<String, Double>();
    private final Map<String, Double> scoringErrors = new ConcurrentHashMap<String, Double>();

    public WeightedWorkloadMetricsReporter(MetricsFacade metrics) {
        this.metrics = metrics.workload();
    }

    void reportCurrentScore(String consumerId, double score) {
        if (!this.currentScores.containsKey(consumerId)) {
            this.metrics.registerCurrentScoreGauge(consumerId, this.currentScores, scores -> scores.getOrDefault(consumerId, 0.0));
        }
        this.currentScores.put(consumerId, score);
    }

    void reportProposedScore(String consumerId, double score) {
        if (!this.currentScores.containsKey(consumerId)) {
            this.metrics.registerProposedErrorGauge(consumerId, this.proposedScores, scores -> scores.getOrDefault(consumerId, 0.0));
        }
        this.proposedScores.put(consumerId, score);
    }

    void reportScoringError(String consumerId, double error) {
        if (!this.scoringErrors.containsKey(consumerId)) {
            this.metrics.registerScoringErrorGauge(consumerId, this.scoringErrors, errors -> errors.getOrDefault(consumerId, 0.0));
        }
        this.scoringErrors.put(consumerId, error);
    }

    void reportCurrentWeights(Collection<ConsumerNode> consumers) {
        for (ConsumerNode consumerNode : consumers) {
            String consumerId = consumerNode.getConsumerId();
            if (!this.currentWeights.containsKey(consumerId)) {
                this.metrics.registerCurrentWeightGauge(consumerId, this.currentWeights, weights -> weights.getOrDefault(consumerId, 0.0));
            }
            this.currentWeights.put(consumerId, consumerNode.getWeight().getOperationsPerSecond());
        }
    }

    void reportProposedWeights(Map<String, Weight> newWeights) {
        for (Map.Entry<String, Weight> entry : newWeights.entrySet()) {
            String consumerId = entry.getKey();
            if (!this.proposedWeights.containsKey(consumerId)) {
                this.metrics.registerProposedWeightGauge(consumerId, this.proposedWeights, weights -> weights.getOrDefault(consumerId, 0.0));
            }
            this.proposedWeights.put(consumerId, entry.getValue().getOperationsPerSecond());
        }
    }

    void unregisterLeaderMetrics() {
        this.unregisterMetricsForConsumersOtherThan(Collections.emptySet());
    }

    void unregisterMetricsForConsumersOtherThan(Set<String> consumerIds) {
        this.metrics.unregisterAllWorkloadWeightedGaugesForConsumerIds(this.findConsumerIdsToRemove(consumerIds));
    }

    private Set<String> findConsumerIdsToRemove(Set<String> activeIds) {
        return Sets.newHashSet((Iterable)Iterables.concat((Iterable[])new Iterable[]{this.currentScores.keySet(), this.proposedScores.keySet(), this.scoringErrors.keySet(), this.currentWeights.keySet(), this.proposedWeights.keySet()})).stream().filter(consumerId -> !activeIds.contains(consumerId)).collect(Collectors.toSet());
    }
}

