/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import java.net.URI;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import org.apache.avro.Schema;
import org.glassfish.jersey.client.ClientConfig;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import pl.allegro.tech.hermes.common.metric.HermesMetrics;
import pl.allegro.tech.hermes.common.schema.AvroCompiledSchemaRepositoryFactory;
import pl.allegro.tech.hermes.common.schema.RawSchemaClientFactory;
import pl.allegro.tech.hermes.common.schema.SchemaRepositoryFactory;
import pl.allegro.tech.hermes.common.schema.SchemaVersionRepositoryParameters;
import pl.allegro.tech.hermes.common.schema.SchemaVersionsRepositoryFactory;
import pl.allegro.tech.hermes.consumers.config.KafkaClustersProperties;
import pl.allegro.tech.hermes.consumers.config.SchemaProperties;
import pl.allegro.tech.hermes.domain.notifications.InternalNotificationsBus;
import pl.allegro.tech.hermes.schema.CompiledSchemaRepository;
import pl.allegro.tech.hermes.schema.RawSchemaClient;
import pl.allegro.tech.hermes.schema.SchemaRepository;
import pl.allegro.tech.hermes.schema.SchemaVersionsRepository;
import pl.allegro.tech.hermes.schema.resolver.DefaultSchemaRepositoryInstanceResolver;
import pl.allegro.tech.hermes.schema.resolver.SchemaRepositoryInstanceResolver;

@Configuration
@EnableConfigurationProperties(value={SchemaProperties.class, KafkaClustersProperties.class})
public class SchemaConfiguration {
    @Bean
    public SchemaRepository schemaRepository(SchemaVersionsRepository schemaVersionsRepository, CompiledSchemaRepository<Schema> compiledAvroSchemaRepository) {
        return new SchemaRepositoryFactory(schemaVersionsRepository, compiledAvroSchemaRepository).provide();
    }

    @Bean
    public CompiledSchemaRepository<Schema> avroCompiledSchemaRepository(RawSchemaClient rawSchemaClient, SchemaProperties schemaProperties) {
        return new AvroCompiledSchemaRepositoryFactory(rawSchemaClient, schemaProperties.getCache().getCompiledMaximumSize(), schemaProperties.getCache().getCompiledExpireAfterAccess(), schemaProperties.getCache().isEnabled()).provide();
    }

    @Bean
    public RawSchemaClient rawSchemaClient(HermesMetrics hermesMetrics, ObjectMapper objectMapper, SchemaRepositoryInstanceResolver resolver, SchemaProperties schemaProperties, KafkaClustersProperties kafkaProperties) {
        return new RawSchemaClientFactory(kafkaProperties.getNamespace(), kafkaProperties.getNamespaceSeparator(), hermesMetrics, objectMapper, resolver, schemaProperties.getRepository().isSubjectSuffixEnabled(), schemaProperties.getRepository().isSubjectNamespaceEnabled()).provide();
    }

    @Bean
    public SchemaRepositoryInstanceResolver schemaRepositoryInstanceResolver(SchemaProperties schemaProperties, Client client) {
        URI schemaRepositoryServerUri = URI.create(schemaProperties.getRepository().getServerUrl());
        return new DefaultSchemaRepositoryInstanceResolver(client, schemaRepositoryServerUri);
    }

    @Bean
    public Client schemaRepositoryClient(ObjectMapper mapper, SchemaProperties schemaProperties) {
        ClientConfig config = new ClientConfig().property("jersey.config.client.readTimeout", (Object)((int)schemaProperties.getRepository().getHttpReadTimeout().toMillis())).property("jersey.config.client.connectTimeout", (Object)((int)schemaProperties.getRepository().getHttpConnectTimeout().toMillis())).register((Object)new JacksonJsonProvider(mapper));
        return ClientBuilder.newClient((javax.ws.rs.core.Configuration)config);
    }

    @Bean
    public SchemaVersionsRepository schemaVersionsRepositoryFactory(RawSchemaClient rawSchemaClient, SchemaProperties schemaProperties, InternalNotificationsBus notificationsBus, CompiledSchemaRepository<?> compiledSchemaRepository) {
        return new SchemaVersionsRepositoryFactory(rawSchemaClient, (SchemaVersionRepositoryParameters)schemaProperties.getCache(), notificationsBus, compiledSchemaRepository).provide();
    }
}

