/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.result;

import java.time.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.api.SentMessageTrace;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.common.message.undelivered.UndeliveredMessageLog;
import pl.allegro.tech.hermes.consumers.consumer.Message;
import pl.allegro.tech.hermes.consumers.consumer.SubscriptionMetrics;
import pl.allegro.tech.hermes.consumers.consumer.message.MessageConverter;
import pl.allegro.tech.hermes.consumers.consumer.offset.OffsetQueue;
import pl.allegro.tech.hermes.consumers.consumer.offset.SubscriptionPartitionOffset;
import pl.allegro.tech.hermes.consumers.consumer.result.ErrorHandler;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageSendingResult;
import pl.allegro.tech.hermes.tracker.consumers.Trackers;

public class DefaultErrorHandler
implements ErrorHandler {
    private static final Logger logger = LoggerFactory.getLogger(DefaultErrorHandler.class);
    private final OffsetQueue offsetQueue;
    private final SubscriptionMetrics metrics;
    private final UndeliveredMessageLog undeliveredMessageLog;
    private final Clock clock;
    private final Trackers trackers;
    private final String cluster;

    public DefaultErrorHandler(OffsetQueue offsetQueue, SubscriptionMetrics metrics, UndeliveredMessageLog undeliveredMessageLog, Clock clock, Trackers trackers, String cluster) {
        this.offsetQueue = offsetQueue;
        this.metrics = metrics;
        this.undeliveredMessageLog = undeliveredMessageLog;
        this.clock = clock;
        this.trackers = trackers;
        this.cluster = cluster;
    }

    @Override
    public void handleDiscarded(Message message, Subscription subscription, MessageSendingResult result) {
        this.logResult(message, subscription, result);
        this.offsetQueue.offerCommittedOffset(SubscriptionPartitionOffset.subscriptionPartitionOffset(subscription.getQualifiedName(), message.getPartitionOffset(), message.getPartitionAssignmentTerm()));
        this.metrics.markDiscarded(message);
        this.addToMessageLog(message, subscription, result);
        this.trackers.get(subscription).logDiscarded(MessageConverter.toMessageMetadata(message, subscription), result.getRootCause());
    }

    private void addToMessageLog(Message message, Subscription subscription, MessageSendingResult result) {
        result.getLogInfo().forEach(logInfo -> this.undeliveredMessageLog.add(SentMessageTrace.Builder.undeliveredMessage().withSubscription(subscription.getName()).withTopicName(subscription.getQualifiedTopicName()).withMessage(new String(message.getData())).withReason(logInfo.getFailure().getMessage()).withTimestamp(this.clock.millis()).withPartition(Integer.valueOf(message.getPartition())).withOffset(Long.valueOf(message.getOffset())).withCluster(this.cluster).build()));
    }

    private void logResult(Message message, Subscription subscription, MessageSendingResult result) {
        if (result.isLoggable()) {
            result.getLogInfo().forEach(logInfo -> logger.warn("Abnormal delivery failure: subscription: {}; cause: {}; endpoint: {}; messageId: {}; partition: {}; offset: {}", new Object[]{subscription.getQualifiedName(), logInfo.getRootCause(), logInfo.getUrlString(), message.getId(), message.getPartition(), message.getOffset(), logInfo.getFailure()}));
        }
    }

    @Override
    public void handleFailed(Message message, Subscription subscription, MessageSendingResult result) {
        this.metrics.markFailure(message, result);
        this.trackers.get(subscription).logFailed(MessageConverter.toMessageMetadata(message, subscription), result.getRootCause(), result.getHostname());
    }
}

