/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import javax.ws.rs.core.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import pl.allegro.tech.hermes.common.exception.InternalProcessingException;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageSendingResult;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageSendingResultLogInfo;

public class SingleMessageSendingResult
implements MessageSendingResult {
    private Throwable failure;
    private boolean loggable;
    private boolean ignoreInRateCalculation = false;
    private Optional<Long> retryAfterMillis = Optional.empty();
    private Optional<URI> requestUri = Optional.empty();
    private int statusCode;
    private Response.Status.Family responseFamily;

    SingleMessageSendingResult(Throwable failure, boolean ignoreInRateCalculation) {
        this.failure = failure;
        this.loggable = !this.isTimeout();
        this.ignoreInRateCalculation = ignoreInRateCalculation;
    }

    SingleMessageSendingResult(Throwable failure) {
        this(failure, false);
    }

    SingleMessageSendingResult(Result result) {
        this.failure = result.getFailure();
        if (result.getResponse() != null) {
            this.initializeForStatusCode(result.getResponse().getStatus());
            if (this.shouldRetryOnStatusCode()) {
                this.initializeRetryAfterMillis(result);
            }
        }
        this.loggable = !this.isTimeout() && !this.hasHttpAnswer();
        this.requestUri = Optional.ofNullable(result.getRequest().getURI());
    }

    SingleMessageSendingResult(int statusCode) {
        this.initializeForStatusCode(statusCode);
    }

    SingleMessageSendingResult(int statusCode, URI requestURI) {
        this(statusCode);
        this.requestUri = Optional.of(requestURI);
    }

    SingleMessageSendingResult(int statusCode, long retryAfterMillis) {
        this.initializeForStatusCode(statusCode);
        if (this.shouldRetryOnStatusCode() && retryAfterMillis >= 0L) {
            this.retryAfterMillis = Optional.of(retryAfterMillis);
        }
    }

    public SingleMessageSendingResult(Result result, URI uri) {
        this(result);
        this.requestUri = Optional.of(uri);
    }

    private void initializeForStatusCode(int statusCode) {
        this.statusCode = statusCode;
        this.responseFamily = Response.Status.Family.familyOf((int)statusCode);
        if (this.failure == null && !this.isInFamily(Response.Status.Family.SUCCESSFUL)) {
            this.failure = new InternalProcessingException("Message sending failed with status code: " + statusCode);
        }
    }

    private void initializeRetryAfterMillis(Result result) {
        HttpFields headers = result.getResponse().getHeaders();
        if (headers.contains(HttpHeader.RETRY_AFTER)) {
            try {
                int seconds = Integer.parseInt(headers.get(HttpHeader.RETRY_AFTER));
                if (seconds >= 0) {
                    this.retryAfterMillis = Optional.of(TimeUnit.SECONDS.toMillis(seconds));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private boolean isInFamily(Response.Status.Family family) {
        Preconditions.checkNotNull((Object)family);
        return family.equals((Object)this.responseFamily);
    }

    @Override
    public boolean isRetryLater() {
        return this.shouldRetryOnStatusCode() && this.retryAfterMillis.isPresent();
    }

    private boolean shouldRetryOnStatusCode() {
        return this.getStatusCode() == HttpResponseStatus.SERVICE_UNAVAILABLE.code() || this.getStatusCode() == HttpResponseStatus.TOO_MANY_REQUESTS.code();
    }

    @Override
    public boolean succeeded() {
        return this.getFailure() == null;
    }

    Throwable getFailure() {
        return this.failure;
    }

    @Override
    public String getRootCause() {
        return this.failure != null ? Throwables.getRootCause((Throwable)this.failure).getMessage() : "unknown";
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public boolean isLoggable() {
        return this.loggable;
    }

    @Override
    public Optional<Long> getRetryAfterMillis() {
        return this.retryAfterMillis;
    }

    public Optional<URI> getRequestUri() {
        return this.requestUri;
    }

    @Override
    public boolean isClientError() {
        return this.isInFamily(Response.Status.Family.CLIENT_ERROR);
    }

    @Override
    public boolean ignoreInRateCalculation(boolean retryClientErrors, boolean isOAuthSecuredSubscription) {
        return this.isRetryLater() || this.ignoreInRateCalculation || this.isClientError() && !retryClientErrors && (!isOAuthSecuredSubscription || !this.isUnauthorized());
    }

    private boolean isUnauthorized() {
        return this.getStatusCode() == HttpResponseStatus.UNAUTHORIZED.code();
    }

    @Override
    public boolean isTimeout() {
        return this.failure instanceof TimeoutException;
    }

    @Override
    public List<MessageSendingResultLogInfo> getLogInfo() {
        return Collections.singletonList(new MessageSendingResultLogInfo(this.getRequestUri(), this.failure, this.getRootCause()));
    }

    @Override
    public List<URI> getSucceededUris(Predicate<MessageSendingResult> filter) {
        if (filter.test(this) && this.requestUri.isPresent()) {
            return Collections.singletonList(this.getRequestUri().get());
        }
        return Collections.emptyList();
    }
}

